<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-12">

        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="{{ route('admin.terms') }}" class="text-dark">
                    {{ 'Terms & Conditions' }}
                </a>
            </h6>
        </div>
        <!-- page header end -->

        <form action="{{ route('admin.terms.store') }}" method="POST">
            <!-- card start -->
            @csrf
            <div class="card">
                <div class="card-body pb-0">
                    <div id="doctor-form" class="form">

                        <div class="row">
                            <!-- terms -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="content" class="form-label mb-1 fw-medium">Add Information on Terms & Conditions</label>
                                    <textarea class="form-control" id="content" name="content" rows="10" placeholder="Brief description about the terms & conditions rules" required></textarea>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- card end -->

            <div class="d-flex align-items-center justify-content-end">
                <button type="submit" class="btn btn-primary">
                    <span><i class="ti ti-plus"></i> Add Terms & Conditions</span>
                </button>
            </div>
        </form>
    
        <!-- Header Text -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h6 class="fw-bold mb-0">
                    {{ 'Terms & Conditions List' }} 
                </h6>
            </div>
        </div>

        <!-- Table Start --> 
         
        <div class="table-responsive">
            <table class="table datatable table-nowrap mt-4">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>Content</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($terms as $index => $term)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $term->content }}</td>
                            <td>
                                <a href="{{ route('admin.terms.toggle-status', $term->id) }}"
                                class="badge {{ $term->status == 'active' ? 'badge-soft-success border border-success' : 'badge-soft-danger border border-danger' }}">
                                {{ ucfirst($term->status) }}
                                </a>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <a href="#" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical"></i></a>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li><a class="dropdown-item" href="{{ route('admin.terms.edit', $term->id) }}"><i class="ti ti-edit me-2"></i>Edit</a></li>
                                        <li><a class="dropdown-item text-danger" href="{{ route('admin.terms.delete', $term->id) }}"><i class="ti ti-trash me-2"></i>Delete</a></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center text-muted">No terms found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            {{ $terms->links() }}
        </div>
    </div>                   
</div>


