<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-12">
        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="{{ route('admin.notification') }}" class="text-dark">
                    <!-- <i class="ti ti-chevron-left me-1"></i> -->
                    {{ 'Notification' }}
                </a>
            </h6>
        </div>
        <!-- page header end -->

        <!-- card start -->
        <div class="card">
            <div class="card-body pb-0">
                <div id="doctor-form" class="form">

                    <div class="row">
                        <!-- Bio -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label mb-1 fw-medium">
                                    User Name<span class="text-danger ms-1">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" wire:model="name" placeholder="Enter user's full name">
                                @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Notification Title -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="title" class="form-label mb-1 fw-medium">
                                    Notification Title<span class="text-danger ms-1">*</span>
                                </label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" wire:model="title" placeholder="Enter notification title">
                                @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Notification Body -->
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="notification" class="form-label mb-1 fw-medium">Send Notification</label>
                                <textarea class="form-control @error('notification') is-invalid @enderror" id="notification" rows="10" wire:model="notification"
                                        placeholder="Write the notification message here"></textarea>
                                @error('notification')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        
                    </div>
                </div>
            </div>
        </div>
        <!-- card end -->

        <div class="d-flex align-items-center justify-content-end">
            <!-- <button type="button" class="btn btn-light me-2">
                <i class="ti ti-refresh"></i> Reset Form
            </button> -->
            <button type="submit" class="btn btn-primary">
                <span>
                    <i class="ti ti-plus"></i> Add Notification
                </span>
                <!-- <span wire:loading>
                    <i class="ti ti-loader fa-spin"></i> Processing...
                </span> -->
            </button>
        </div>


        <!-- Header Text -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h6 class="fw-bold mb-0">
                    Notifications List
                </h6>
            </div>
        </div>

        <!-- Notification Table -->
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>User Name</th>
                        <th>Notification Title</th>
                        <th>Message</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $notifications = [
                            ['id' => 1, 'name' => 'John Doe', 'title' => 'Account Alert', 'message' => 'Your account has been updated.'],
                            ['id' => 2, 'name' => 'Jane Smith', 'title' => 'Reminder', 'message' => 'Don\'t forget your appointment tomorrow.'],
                            ['id' => 3, 'name' => 'Robert Brown', 'title' => 'Offer', 'message' => 'You have a new discount available.'],
                        ];
                    @endphp

                    @foreach ($notifications as $index => $note)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $note['name'] }}</td>
                            <td>{{ $note['title'] }}</td>
                            <td>{{ $note['message'] }}</td>
                            <td>
                                <div class="dropdown">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="text-dark">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="#" class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#" class="dropdown-item d-flex align-items-center text-danger">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>
