<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-12">

        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="{{ route('admin.faq') }}" class="text-dark">
                    <!-- <i class="ti ti-chevron-left me-1"></i> -->
                    {{ 'Frequently Asked Questions (FAQ)' }}
                </a>
            </h6>
        </div>
        <!-- page header end -->

        <!-- card start -->
        <div class="card">
            <div class="card-body pb-0">
                <div id="doctor-form" class="form">

                    <div class="row">
                        <!-- FAQ -->
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="question" class="form-label mb-1 fw-medium">FAQ Question</label>
                                <input type="text" class="form-control @error('question') is-invalid @enderror" id="question" wire:model="question" placeholder="Enter FAQ question here"> @error('question') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="mb-3">
                                <label for="answer" class="form-label mb-1 fw-medium">Answer</label>
                                <textarea class="form-control @error('answer') is-invalid @enderror" id="answer" rows="4" wire:model="answer" placeholder="Enter the answer for this FAQ"></textarea> @error('answer') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
 
                    </div>
                </div>
            </div>
        </div>
        <!-- card end -->

        <div class="d-flex align-items-center justify-content-end">
            <!-- <button type="button" class="btn btn-light me-2">
                <i class="ti ti-refresh"></i> Reset Form
            </button> -->
            <button type="submit" class="btn btn-primary">
                <span>
                    <i class="ti ti-plus"></i> Add FAQ
                </span>
                <!-- <span wire:loading>
                    <i class="ti ti-loader fa-spin"></i> Processing...
                </span> -->
            </button>
        </div>

        <!-- Header Text -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h6 class="fw-bold mb-0">
                    {{ 'Frequently Asked Questions List' }}
                </h6>
            </div>
        </div>

        <!-- Table Start -->
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>FAQ Question</th>
                        <th>Answer</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $faqs = [
                            ['id' => 1, 'question' => 'How can I register?', 'answer' => 'Click on the Register button and fill out the form.'],
                            ['id' => 2, 'question' => 'Is my data secure?', 'answer' => 'Yes, we use advanced encryption to protect your data.'],
                            ['id' => 3, 'question' => 'Can I change my password?', 'answer' => 'Go to settings and select "Change Password".'],
                        ];
                    @endphp

                    @foreach($faqs as $index => $faq)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $faq['question'] }}</td>
                            <td>{{ $faq['answer'] }}</td>
                            <td>
                                <div class="dropdown">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="text-dark">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="#" class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center text-danger">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>
