<div class="content">

    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                Feature Management
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Features: {{ $features->total() ?? 0 }}
                </span>
            </h4>
        </div>

        <div class="text-end d-flex">
            <!-- dropdown-->
            {{--
<              div class="dropdown me-1">
                <a href="javascript:void(0);"
                    class="btn btn-md fs-14 fw-normal border bg-white rounded text-dark d-inline-flex align-items-center"
                    data-bs-toggle="dropdown">
                    Export<i class="ti ti-chevron-down ms-2"></i>
                </a>
                <ul class="dropdown-menu p-2 bg-white">
                    <li>
                        <a class="dropdown-item" href="#">Download as PDF</a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="#">Download as Excel</a>
                    </li>
                </ul>
            </div>
            <div
                class="bg-white border shadow-sm rounded px-1 pb-0 text-center d-flex align-items-center justify-content-center">
                <a href="doctors-list.html"
                    class="bg-light rounded p-1 d-flex align-items-center justify-content-center"> <i
                        class="ti ti-list fs-14 text-dark"></i></a>
                <a href="doctors.html" class="bg-white rounded p-1 d-flex align-items-center justify-content-center"> <i
                        class="ti ti-layout-grid fs-14 text-body"></i> </a>
            </div>
            --}}

            <a href="{{ route('admin.plans.features.create') }}" class="btn btn-primary ms-2 fs-13 btn-md"><i
                    class="ti ti-plus me-1"></i>Add New Feature</a>
        </div>
    </div>
    <!-- End Page Header -->

    {{-- Success Message --}}
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class=" d-flex align-items-center justify-content-between flex-wrap row-gap-3">
        <div class="search-set mb-3">
            <div class="d-flex align-items-center flex-wrap gap-2">
                <div class="table-search d-flex align-items-center mb-0">
                    <div class="search-input">
                        <a href="javascript:void(0);" class="btn-searchset"></a>
                        <div id="DataTables_Table_0_filter" class="dataTables_filter"><label> <input type="search"
                                    class="form-control form-control-sm" placeholder="Search features..."
                                    wire:model.live.debounce.300ms="search" aria-controls="DataTables_Table_0"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                wire:click="clearAllFilters">Clear All</a>
                        </div>
                    </div>
                    <div class="filter-body pb-0">
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Status</label>
                                <a href="javascript:void(0);" class="link-primary mb-1"
                                    wire:click="resetStatusFilter">Reset</a>
                            </div>
                            <select class="form-select" wire:model="statusFilter">
                                <option value="all">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="beta">Beta</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Base Feature</label>
                                <a href="javascript:void(0);" class="link-primary mb-1"
                                    wire:click="resetBaseFeatureFilter">Reset</a>
                            </div>
                            <select class="form-select" wire:model="baseFeatureFilter">
                                <option value="all">All Features</option>
                                <option value="yes">Base Features</option>
                                <option value="no">Non-Base Features</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Category</label>
                                <a href="javascript:void(0);" class="link-primary mb-1"
                                    wire:click="resetCategoryFilter">Reset</a>
                            </div>
                            <select class="form-select" wire:model="categoryFilter">
                                <option value="all">All Categories</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category }}">{{ $category }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                        <a href="javascript:void(0);" class="btn btn-light btn-md me-2"
                            data-bs-toggle="dropdown">Close</a>
                        <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters"
                            data-bs-toggle="dropdown">Filter</button>
                    </div>
                </div>
            </div>
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1"> Sort By : </span> Recent
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('feature_code')">Feature Code</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('feature_name')">Feature Name</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('feature_status')">Status</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Recently Added</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Last 7 Days</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th wire:click="sortBy('feature_code')" style="cursor: pointer;">
                        Code {!! $sortField === 'feature_code' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th wire:click="sortBy('feature_name')" style="cursor: pointer;">
                        Name {!! $sortField === 'feature_name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th>Description</th>
                    <th>Category</th>
                    <th>Base Feature</th>
                    <th wire:click="sortBy('feature_status')" style="cursor: pointer;">
                        Status {!! $sortField === 'feature_status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($features as $feature)
                    <tr>
                        <td>
                            <span class="fs-13">{{ $feature->feature_code }}</span>
                        </td>
                        <td>
                            <span class="text-dark fw-semibold">{{ $feature->feature_name }}</span>
                        </td>
                        <td>
                            <span class="fs-13">{{ Str::limit($feature->description, 50) }}</span>
                        </td>
                        <td>
                            <span class="fs-13">{{ $feature->category ?? 'N/A' }}</span>
                        </td>
                        <td>
                            @if ($feature->is_base_feature)
                                <span class="badge badge-soft-success border border-success">Yes</span>
                            @else
                                <span class="badge badge-soft-danger border border-danger">No</span>
                            @endif
                        </td>
                        <td>
                            @if ($feature->feature_status === 'active')
                                <span class="badge badge-soft-success border border-success">Active</span>
                            @elseif ($feature->feature_status === 'beta')
                                <span class="badge badge-soft-info border border-info">Beta</span>
                            @else
                                <span class="badge badge-soft-danger border border-danger">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="action-item">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="{{ route('admin.plans.features.edit', $feature) }}"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);"
                                                class="dropdown-item d-flex align-items-center"
                                                wire:click="toggleStatus({{ $feature->id }})">
                                                <i class="ti ti-power me-2"></i>
                                                {{ $feature->feature_status === 'active' ? 'Deactivate' : 'Activate' }}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);"
                                                class="dropdown-item d-flex align-items-center text-danger"
                                                wire:click="$set('deleteId' , {{ $feature->id }})"
                                                data-bs-toggle="modal" data-bs-target="#delete_feature">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">No features found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- Pagination --}}
    <x-table.pagination :paginator="$features" :position="'both'" />


    <!-- Start Delete Modal -->
    <div class="modal fade" id="delete_feature" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                   <img src="{{ asset('assets/img/bg/delete-modal-bg-01.png') }}" alt=""
                        class="img-fluid position-absolute top-0 start-0">
                    <img src="{{ asset('assets/img/bg/delete-modal-bg-02.png') }}" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    @if ($deleteId)
                        <p class="mb-3">Are you sure you want to delete ?</p>
                    @endif
                    <div class="d-flex justify-content-center">
                        <button class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</button>
                        <button class="btn btn-danger position-relative z-1" wire:click="delete({{ $deleteId }})"
                            data-bs-dismiss="modal">Yes, Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->
</div>
