<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.plans.addons.index') }}" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i>{{ isset($addon) ? 'Edit AddOn' : 'Add AddOn' }}
                    </a>
                </h6>
            </div>

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5>{{ isset($addon) && $addon->exists ? 'Edit Addon' : 'Add New Addon' }}</h5>
                            <a href="{{ route('admin.plans.addons.index') }}" class="btn btn-sm btn-secondary">Back</a>
                        </div>

                        <div class="card-body">
                            @if (session()->has('message'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{ session('message') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="addon_code" class="form-label">Addon Code <span
                                            class="text-danger">*</span></label>
                                    <input wire:model.live="addon_code" type="text" id="addon_code"
                                        class="form-control @error('addon_code') is-invalid @enderror"
                                        placeholder="e.g., STORAGE_ADDON">
                                    @error('addon_code')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="name" class="form-label">Addon Name <span
                                            class="text-danger">*</span></label>
                                    <input wire:model.live="name" type="text" id="name"
                                        class="form-control @error('name') is-invalid @enderror"
                                        placeholder="e.g., Extra Storage">
                                    @error('name')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-12">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea wire:model.live="description" id="description" class="form-control @error('description') is-invalid @enderror"
                                        rows="3" placeholder="Addon description"></textarea>
                                    @error('description')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="resource_type" class="form-label">Resource Type <span
                                            class="text-danger">*</span></label>
                                    <select wire:model.live="resource_type" id="resource_type"
                                        class="form-select @error('resource_type') is-invalid @enderror">
                                        @foreach ($resourceTypes as $key => $value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                    @error('resource_type')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="unit" class="form-label">Unit <span
                                            class="text-danger">*</span></label>
                                    <input wire:model.live="unit" type="text" id="unit"
                                        class="form-control @error('unit') is-invalid @enderror"
                                        placeholder="e.g., GB, User, Call" readonly>
                                    @error('unit')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="price_per_unit" class="form-label">Price per {{ $unit }} <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">INR</span>
                                        <input wire:model.live="price_per_unit" type="number" step="0.01"
                                            id="price_per_unit"
                                            class="form-control @error('price_per_unit') is-invalid @enderror"
                                            placeholder="0.00">
                                    </div>
                                    @error('price_per_unit')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="unit_counts" class="form-label">Unit Count <span
                                            class="text-danger">*</span></label>
                                    <input wire:model.live="unit_counts" type="number" step="0.01"
                                        id="unit_counts"
                                        class="form-control @error('unit_counts') is-invalid @enderror"
                                        placeholder="0.00">
                                    @error('unit_counts')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Status</label>
                                    <div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" wire:model="is_active"
                                                id="is_active">
                                            <label class="form-check-label" for="is_active">Is this addon
                                                active?</label>
                                        </div>
                                    </div>
                                    @error('is_active')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-12">
                                    <button wire:click="save" class="btn btn-primary float-end">
                                        {{ isset($addon) && $addon->exists ? 'Update Addon' : 'Create Addon' }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
