<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-10">
        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="{{ route('admin.doctor-management') }}" class="text-dark">
                    <i class="ti ti-chevron-left me-1"></i>{{ $editId ? 'Edit Doctor' : 'Add New Doctor' }}
                </a>
            </h6>
        </div>
        <!-- page header end -->

        <!-- card start -->
        <div class="card">
            <div class="card-body pb-0">
                <div id="doctor-form" class="form">
                    <!-- Flash Messages -->
                    @if (session()->has('message'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('message') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <h6 class="fw-bold mb-3">Basic Information</h6>

                    <div class="row">
                        <!-- Profile Image -->
                        <div class="col-lg-12">
                            <div class="mb-3 d-flex align-items-center">
                                <label class="form-label mb-0 fw-medium">Profile Image</label>
                                <div
                                    class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">

                                    @php
                                        $imageUrl = $this->getProfileImageUrl();
                                    @endphp

                                    @if ($imageUrl)
                                        <!-- Show current image -->
                                        <img src="{{ $imageUrl }}" alt="Profile" class="w-100 h-100"
                                            style="object-fit: cover;">
                                        <!-- Remove button -->
                                        <div class="position-absolute top-0 end-0 m-1">
                                            <button type="button" wire:click="removeProfileImage"
                                                class="btn btn-danger btn-sm rounded-circle p-1"
                                                style="width: 24px; height: 24px; z-index: 10;">
                                                <i class="ti ti-x fs-12"></i>
                                            </button>
                                        </div>
                                    @else
                                        <!-- Show placeholder when no image -->
                                        <i class="ti ti-user-plus fs-16"></i>
                                    @endif

                                    <!-- File input -->
                                    <input type="file" wire:model="profile_image"
                                        class="form-control image-sign position-absolute top-0 start-0 w-100 h-100 opacity-0"
                                        accept="image/*" style="cursor: pointer;">

                                    <!-- Camera icon overlay -->
                                    <div class="position-absolute bottom-0 end-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center"
                                        style="z-index: 1;">
                                        <span class="text-white d-flex align-items-center justify-content-center">
                                            <i class="ti ti-photo fs-14"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Loading indicator -->
                            <div wire:loading wire:target="profile_image" class="text-primary">
                                <small><i class="spinner-border spinner-border-sm me-1"></i>Uploading image...</small>
                            </div>

                            <!-- Error display -->
                            @error('profile_image')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Name -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label mb-1 fw-medium">Full Name<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" wire:model="name" placeholder="Enter doctor's full name">
                                @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label mb-1 fw-medium">Email<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror"
                                    id="email" wire:model="email" placeholder="doctor@example.com">
                                @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Password Fields -->
                        @if (!$editId)
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label mb-1 fw-medium">Password<span
                                            class="text-danger ms-1">*</span></label>
                                    <input type="password" class="form-control @error('password') is-invalid @enderror"
                                        id="password" wire:model="password" placeholder="Enter secure password">
                                    @error('password')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label mb-1 fw-medium">Confirm
                                        Password<span class="text-danger ms-1">*</span></label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        wire:model="password_confirmation" placeholder="Confirm password">
                                </div>
                            </div>
                        @else
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label mb-1 fw-medium">New Password</label>
                                    <input type="password"
                                        class="form-control @error('password') is-invalid @enderror" id="password"
                                        wire:model="password" placeholder="Enter new password">
                                    @error('password')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label mb-1 fw-medium">Confirm New
                                        Password</label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        wire:model="password_confirmation" placeholder="Confirm new password">
                                </div>
                            </div>
                        @endif

                        <!-- Status -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Status<span
                                        class="text-danger ms-1">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" wire:model="status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                                @error('status')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Professional Information Section -->
                        <h6 class="fw-bold mb-3 border-top pt-3">Professional Information</h6>

                        <!-- Specialization -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="specialization" class="form-label mb-1 fw-medium">Specialization<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text"
                                    class="form-control @error('specialization') is-invalid @enderror"
                                    id="specialization" wire:model="specialization"
                                    placeholder="e.g., Cardiology, Pediatrics">
                                @error('specialization')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- License Number -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="license_number" class="form-label mb-1 fw-medium">License Number<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text"
                                    class="form-control @error('license_number') is-invalid @enderror"
                                    id="license_number" wire:model="license_number"
                                    placeholder="Medical license number">
                                @error('license_number')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Qualifications -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="qualifications" class="form-label mb-1 fw-medium">Qualifications</label>
                                <input type="text"
                                    class="form-control @error('qualifications') is-invalid @enderror"
                                    id="qualifications" wire:model="qualifications"
                                    placeholder="e.g., MD, MBBS, PhD">
                                @error('qualifications')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Experience Years -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="experience_years" class="form-label mb-1 fw-medium">Years of
                                    Experience</label>
                                <input type="number"
                                    class="form-control @error('experience_years') is-invalid @enderror"
                                    id="experience_years" wire:model="experience_years" min="0"
                                    placeholder="0">
                                @error('experience_years')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Bio -->
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="bio" class="form-label mb-1 fw-medium">Bio</label>
                                <textarea class="form-control @error('bio') is-invalid @enderror" id="bio" rows="3" wire:model="bio"
                                    placeholder="Brief description about the doctor's background and expertise"></textarea>
                                @error('bio')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Clinic Assignments Section -->
                        <h6 class="fw-bold mb-3 border-top pt-3">Clinic Assignments</h6>

                        <div class="col-12">
                            @if ($has_primary_clinic)
                                <div class="alert alert-info mb-3">
                                    <i class="fas fa-info-circle me-2"></i>
                                    This doctor has a primary clinic
                                    (<strong>{{ $this->getPrimaryClinicName() }}</strong>).
                                    The primary clinic assignment cannot be changed but you can add or remove other
                                    clinics.
                                </div>
                            @endif

                            <!-- Clinic Search -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Search Clinics</label>
                                <div class="input-icon-end position-relative">
                                    <input type="text" class="form-control" placeholder="Search clinics..."
                                        wire:model.live.debounce.300ms="clinicSearch">
                                    <span class="input-icon-addon">
                                        <i class="ti ti-search"></i>
                                    </span>
                                </div>
                            </div>

                            <!-- Clinics List -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Available Clinics</label>
                                <div class="clinics-list border rounded p-3"
                                    style="max-height: 250px; overflow-y: auto;">
                                    @forelse($this->filteredClinics as $clinic)
                                        @php
                                            $isPrimary = $has_primary_clinic && $clinic->id === $primary_clinic_id;
                                            $isChecked = in_array($clinic->id, $selected_clinics);
                                        @endphp

                                        <div class="form-check py-2 {{ $isPrimary ? 'bg-light rounded px-2' : '' }}">
                                            <input class="form-check-input" type="checkbox"
                                                id="clinic_{{ $clinic->id }}" wire:model.live="selected_clinics"
                                                value="{{ $clinic->id }}"
                                                {{ $isPrimary ? 'checked disabled' : '' }}>

                                            <label
                                                class="form-check-label d-flex justify-content-between align-items-center"
                                                for="clinic_{{ $clinic->id }}">
                                                <span>
                                                    {{ $clinic->name }}
                                                    @if ($isPrimary)
                                                        <span class="badge bg-primary ms-2">Primary</span>
                                                    @endif
                                                </span>

                                                @if ($clinic->address)
                                                    <small class="text-muted">{{ $clinic->address }}</small>
                                                @endif
                                            </label>
                                        </div>
                                    @empty
                                        <div class="text-center text-muted py-3">
                                            <i class="fas fa-search mb-2"></i>
                                            <p class="mb-0">No clinics found</p>
                                            @if (!empty($clinicSearch))
                                                <small>Try adjusting your search terms</small>
                                            @endif
                                        </div>
                                    @endforelse
                                </div>
                                @error('selected_clinics')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Selected Clinics -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Selected Clinics</label>
                                <div class="p-2 rounded bg-light">
                                    @if (count($this->selectedClinicsNames) > 0)
                                        <div class="d-flex flex-wrap gap-2">
                                            @foreach ($this->selectedClinicsNames as $clinicName)
                                                <span class="badge bg-secondary">{{ $clinicName }}</span>
                                            @endforeach
                                        </div>
                                    @else
                                        <span class="text-muted">No clinics selected</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- card end -->

        <div class="d-flex align-items-center justify-content-end">
            <button type="button" wire:click="resetForm" class="btn btn-light me-2">
                <i class="ti ti-refresh"></i> Reset Form
            </button>
            <button type="submit" wire:click="{{ $editId ? 'updateDoctor' : 'createDoctor' }}"
                wire:loading.attr="disabled" class="btn btn-primary">
                <span wire:loading.remove>
                    @if ($editId)
                        <i class="ti ti-device-floppy"></i> Update Doctor
                    @else
                        <i class="ti ti-plus"></i> Add New Doctor
                    @endif
                </span>
                <span wire:loading>
                    <i class="ti ti-loader fa-spin"></i> Processing...
                </span>
            </button>
        </div>
    </div>
</div>


@push('scripts')
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('doctor-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
@endpush
