<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.clinics.index') }}" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i>{{ isset($clinic) && $clinic->exists ? 'Edit Clinic' : 'Add New Clinic' }}
                    </a>
                </h6>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            @if (session()->has('message'))
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    {{ session('message') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif

                            <!-- New Wizard Progress -->
                            <div id="progressbarwizard">
                                <ul class="nav nav-pills nav-justified form-wizard-header mb-3">
                                    <li class="nav-item">
                                        <button href="#step-1" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 {{ $step == 1 ? 'active' : '' }}"
                                            wire:click.prevent="navigateToStep(1)">
                                            <span class="d-none d-sm-inline">Clinic Details</span>
                                        </button>
                                    </li>
                                    <li class="nav-item">
                                        <button href="#step-2" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 {{ $step == 2 ? 'active' : '' }}"
                                            wire:click.prevent="navigateToStep(2)">
                                            <span class="d-none d-sm-inline">Select Owner</span>
                                        </button>
                                    </li>
                                    <li class="nav-item">
                                        <button href="#step-3" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 {{ $step == 3 ? 'active' : '' }}"
                                            wire:click.prevent="navigateToStep(3)" @disabled($this->clinic->exists())>
                                            <span class="d-none d-sm-inline">Review & Save</span>
                                        </button>
                                    </li>
                                </ul>

                                <div class="tab-content b-0 mb-0">
                                    <div id="bar" class="progress mb-3" style="height: 7px;">
                                        <div class="bar progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                            style="width: {{ (($step - 1) / 2) * 100 }}%"></div>
                                    </div>

                                    <!-- Step Content -->
                                    <div class="tab-pane active">
                                        <!-- Step 1: Clinic Details -->
                                        @if ($step === 1)
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label for="name" class="form-label">Clinic Name</label>
                                                    <input wire:model.blur="name" type="text" id="name"
                                                        class="form-control @error('name') is-invalid @enderror" placeholder="Enter clinic name">
                                                    @error('name')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="email" class="form-label">Email</label>
                                                    <input wire:model.defer="email" type="email" id="email"
                                                        class="form-control @error('email') is-invalid @enderror" placeholder="Enter clinic email">
                                                    @error('email')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <!-- Status -->
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label mb-1 fw-medium">Status<span
                                                                class="text-danger ms-1">*</span></label>
                                                        <select
                                                            class="form-select @error('status') is-invalid @enderror"
                                                            wire:model="status">
                                                            <option value="active">Active</option>
                                                            <option value="inactive">Inactive</option>
                                                        </select>
                                                        @error('status')
                                                            <span class="text-danger">{{ $message }}</span>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <label for="about" class="form-label">About</label>
                                                    <textarea wire:model.defer="about" id="about" class="form-control @error('about') is-invalid @enderror" rows="3" placeholder="About the clinic"></textarea>
                                                    @error('about')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="line1" class="form-label">Address Line 1</label>
                                                    <input wire:model.defer="line1" type="text" id="line1"
                                                        class="form-control @error('line1') is-invalid @enderror" placeholder="Address line 1">
                                                    @error('line1')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="line2" class="form-label">Address Line 2</label>
                                                    <input wire:model.defer="line2" type="text" id="line2"
                                                        class="form-control @error('line2') is-invalid @enderror" placeholder="Address line 2">
                                                    @error('line2')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="city" class="form-label">City</label>
                                                    <input wire:model.defer="city" type="text" id="city"
                                                        class="form-control @error('city') is-invalid @enderror" placeholder="City">
                                                    @error('city')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="state" class="form-label">State</label>
                                                    <input wire:model.defer="state" type="text" id="state"
                                                        class="form-control @error('state') is-invalid @enderror" placeholder="State">
                                                    @error('state')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="country" class="form-label">Country</label>
                                                    <input wire:model.defer="country" type="text" id="country"
                                                        class="form-control @error('country') is-invalid @enderror" placeholder="Country">
                                                    @error('country')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="pincode" class="form-label">Pin Code</label>
                                                    <input wire:model.defer="pincode" type="text" id="pincode"
                                                        class="form-control @error('pincode') is-invalid @enderror" placeholder="Pin code">
                                                    @error('pincode')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="form-label">Contact Numbers</label>
                                                    @foreach ($contact_numbers as $index => $number)
                                                        <div class="input-group mb-2">
                                                            <input type="text" class="form-control @error('contact_numbers.*') is-invalid @enderror"
                                                                wire:model.defer="contact_numbers.{{ $index }}"
                                                                placeholder="Contact number">
                                                            <button class="btn btn-outline-danger" type="button"
                                                                wire:click="removeContactNumber({{ $index }})">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    @endforeach
                                                    <button type="button" class="btn btn-sm btn-outline-primary"
                                                        wire:click="addContactNumber">
                                                        <i class="fa fa-plus"></i> Add Contact Number
                                                    </button>
                                                    @error('contact_numbers.*')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="form-label">Specialities</label>
                                                    @foreach ($specialities as $index => $speciality)
                                                        <div class="input-group mb-2">
                                                            <input type="text" class="form-control @error('specialities.*') is-invalid @enderror"
                                                                wire:model.defer="specialities.{{ $index }}"
                                                                placeholder="Speciality">
                                                            <button class="btn btn-outline-danger" type="button"
                                                                wire:click="removeSpeciality({{ $index }})">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    @endforeach
                                                    <button type="button" class="btn btn-sm btn-outline-primary"
                                                        wire:click="addSpeciality">
                                                        <i class="fa fa-plus"></i> Add Speciality
                                                    </button>
                                                    @error('specialities.*')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label">Subscription Plan (Optional)</label>
                                                    <div class="input-group">
                                                        <select wire:model.live="selected_plan_id"
                                                            class="form-select @error('selected_plan_id') is-invalid @enderror">
                                                            <option value="">-- No Plan Selected --</option>
                                                            @foreach ($availablePlans as $plan)
                                                                <option value="{{ $plan->id }}">
                                                                    {{ $plan->plan_name }}
                                                                    ({{ $plan->base_price }}/{{ $plan->plan_type }})
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        @if ($selected_plan_id)
                                                            <button wire:click="$set('selected_plan_id', null)"
                                                                class="btn btn-outline-danger" type="button">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        @endif
                                                    </div>
                                                    @if ($selected_plan_id && $selectedPlanDetails)
                                                        <div class="mt-2 small text-muted">
                                                            Selected: {{ $selectedPlanDetails->plan_name }}
                                                            ({{ $selectedPlanDetails->plan_type }})
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Clinic Add On (Optional)</label>
                                                    <div class="dropdown @error('selected_add_on_id') is-invalid @enderror">
                                                        <!-- Dynamic dropdown button title -->
                                                        <button class="form-select text-start dropdown-toggle"
                                                            type="button" id="addOnDropdown"
                                                            data-bs-toggle="dropdown" aria-expanded="false"
                                                            @disabled(empty($selected_plan_id))>
                                                            @if (count($selected_add_on_id) > 0)
                                                                {{ count($selected_add_on_id) }}
                                                                {{ count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons' }}
                                                                Selected
                                                            @else
                                                                -- Select Add Ons --
                                                            @endif
                                                        </button>

                                                        <!-- Checkbox options -->
                                                        <ul class="dropdown-menu w-100"
                                                            aria-labelledby="addOnDropdown">
                                                            @foreach ($availableAddOns as $addOn)
                                                                <li>
                                                                    <div class="dropdown-item">
                                                                        <input type="checkbox"
                                                                            wire:model="selected_add_on_id"
                                                                            value="{{ $addOn->id }}"
                                                                            id="addon-{{ $addOn->id }}"
                                                                            wire:change="updateSelectedCount">
                                                                        <label for="addon-{{ $addOn->id }}"
                                                                            class="ms-2">
                                                                            {{ $addOn->name }}
                                                                            ({{ $addOn->price_per_unit }}/{{ $addOn->resource_type }})
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>

                                                    <!-- Selected items details -->
                                                    @if (count($selected_add_on_id) > 0)
                                                        <div class="mt-2 small text-muted">
                                                            <strong>Selected:</strong>
                                                            @foreach ($availableAddOns->whereIn('id', $selected_add_on_id) as $selected)
                                                                <span class="d-block">
                                                                    {{ $selected->name }}
                                                                    ({{ $selected->resource_type }})
                                                                </span>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-12">
                                                    <button wire:click="nextStep" class="btn btn-primary float-end">
                                                        Next: Select Owner
                                                    </button>
                                                </div>
                                            </div>
                                        @endif

                                        <!-- Step 2: Select Owner -->
                                        @if ($step === 2 && !$showDoctorForm)
                                            <div class="row g-3">
                                                <div class="col-md-12">
                                                    <h5>Select Clinic Owner</h5>
                                                    <p>Choose an existing doctor or
                                                        {{ $clinic->exists && $clinic->owner ? 'edit' : 'create' }} a
                                                        new one to be
                                                        the
                                                        owner of this clinic.</p>
                                                </div>

                                                @if (!$clinic->exists || !$clinic->owner)
                                                    <div class="col-md-6">
                                                        <label for="owner_id" class="form-label">Select Existing
                                                            Doctor</label>
                                                        <select wire:model.defer="owner_id" id="owner_id"
                                                            class="form-select @error('owner_id') is-invalid @enderror">
                                                            <option value="">Select Owner</option>
                                                            @foreach ($owners as $owner)
                                                                <option value="{{ $owner->id }}">
                                                                    {{ $owner->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        @error('owner_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-12 text-center my-4">
                                                        <p class="text-muted">- OR -</p>
                                                    </div>
                                                @endif

                                                <div class="col-md-12">
                                                    <h5>{{ $clinic->exists && $clinic->owner ? 'Edit' : 'Create New' }}
                                                        Doctor/Owner
                                                    </h5>
                                                    <button wire:click="showNewDoctorForm" type="button"
                                                        class="btn btn-outline-primary">
                                                        <i class="fa fa-plus"></i>
                                                        {{ $clinic->exists && $clinic->owner ? 'Edit Owner Details' : 'Create New Doctor/Owner' }}
                                                    </button>
                                                </div>

                                                <div class="col-12 d-flex justify-content-between">
                                                    <button wire:click="previousStep" type="button"
                                                        class="btn btn-secondary">
                                                        Back
                                                    </button>
                                                    <button wire:click="nextStep" type="button"
                                                        class="btn btn-primary">
                                                        Next: Review
                                                    </button>
                                                </div>
                                            </div>
                                        @endif

                                        <!-- New Doctor Form -->
                                        @if ($showDoctorForm)
                                            <div class="row g-3">
                                                <div class="col-md-12">
                                                    <h5>{{ $editingDoctor ? 'Edit' : 'Create New' }} Doctor/Owner</h5>
                                                    <p>Fill in the details for the
                                                        {{ $editingDoctor ? 'existing' : 'new' }} doctor
                                                        who
                                                        will
                                                        own this clinic.</p>
                                                </div>

                                                <!-- Add a hidden field to track if we're editing -->
                                                <input type="hidden" wire:model="editingDoctor">

                                                <div class="col-md-6">
                                                    <label for="doctor_name" class="form-label">Doctor Name</label>
                                                    <input wire:model="newDoctorData.name" type="text"
                                                        id="doctor_name" class="form-control @error('newDoctorData.name') is-invalid @enderror"
                                                        placeholder="Doctor's full name">
                                                    @error('newDoctorData.name')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_email" class="form-label">Email</label>
                                                    <input wire:model="newDoctorData.email" type="email"
                                                        id="doctor_email" class="form-control @error('newDoctorData.email') is-invalid @enderror"
                                                        placeholder="Doctor's email"
                                                        {{ $editingDoctor ? 'readonly' : '' }}>
                                                    @error('newDoctorData.email')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_password" class="form-label">Password</label>
                                                    <input wire:model="newDoctorData.password" type="password"
                                                        id="doctor_password" class="form-control @error('newDoctorData.password') is-invalid @enderror"
                                                        placeholder="Leave blank to keep current password">
                                                    @error('newDoctorData.password')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_password_confirmation"
                                                        class="form-label">Confirm
                                                        Password</label>
                                                    <input wire:model="newDoctorData.password_confirmation"
                                                        type="password" id="doctor_password_confirmation"
                                                        class="form-control @error('newDoctorData.password_confirmation') is-invalid @enderror" placeholder="Confirm password">
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="specialization"
                                                        class="form-label">Specialization</label>
                                                    <input wire:model="newDoctorData.specialization" type="text"
                                                        id="specialization" class="form-control @error('newDoctorData.specialization') is-invalid @enderror"
                                                        placeholder="Specialization">
                                                    @error('newDoctorData.specialization')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="license_number" class="form-label">License
                                                        Number</label>
                                                    <input wire:model="newDoctorData.license_number" type="text"
                                                        id="license_number" class="form-control @error('newDoctorData.license_number') is-invalid @enderror"
                                                        placeholder="License number"
                                                        {{ $editingDoctor ? 'readonly' : '' }}>
                                                    @error('newDoctorData.license_number')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 d-flex justify-content-between">
                                                    <!-- <button wire:click="showNewDoctorForm = false" type="button"
                                                        class="btn btn-secondary">
                                                        Back to Owner Selection
                                                    </button> -->
                                                    <button wire:click="previousStep" type="button"
                                                        class="btn btn-secondary">
                                                        <i class="fas fa-arrow-left me-2"></i>Back to Owner Selection
                                                    </button>
                                                    <button wire:click="nextStep" type="button"
                                                        class="btn btn-primary">
                                                        Next: Review
                                                    </button>
                                                </div>
                                            </div>
                                        @endif

                                        <!-- Step 3: Review & Save -->
                                        @if ($step === 3)
                                            <div class="review-section">
                                                <div class="row g-4">
                                                    <div class="col-12">
                                                        <div class="card review-card">
                                                            <div class="card-header bg-transparent">
                                                                <h5 class="mb-0"><i
                                                                        class="fas fa-hospital me-2"></i>Clinic
                                                                    Overview
                                                                </h5>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-6 border-end pe-md-4">
                                                                        <div class="clinic-meta">
                                                                            <h3 class="clinic-name mb-3">
                                                                                {{ $name }}</h3>
                                                                            <div class="status-badge mb-3">
                                                                                <span
                                                                                    class="badge rounded-pill bg-{{ $status == 'active' ? 'success' : 'danger' }}">
                                                                                    {{ ucfirst($status) }} Clinic
                                                                                </span>
                                                                            </div>
                                                                            <ul class="clinic-details list-unstyled">
                                                                                <li class="mb-2">
                                                                                    <i
                                                                                        class="fas fa-envelope fa-fw text-muted me-2"></i>
                                                                                    <a href="mailto:{{ $email }}"
                                                                                        class="text-decoration-none">{{ $email }}</a>
                                                                                </li>
                                                                                <li class="mb-2">
                                                                                    <i
                                                                                        class="fas fa-map-marker-alt fa-fw text-muted me-2"></i>
                                                                                    {{ $city }},
                                                                                    {{ $state }},
                                                                                    {{ $country }}
                                                                                </li>
                                                                                <li>
                                                                                    <i
                                                                                        class="fas fa-map-pin fa-fw text-muted me-2"></i>
                                                                                    {{ $pincode }}
                                                                                </li>
                                                                            </ul>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Owner Details -->
                                                                    <div class="col-md-6 ps-md-4">
                                                                        <div class="owner-card">
                                                                            <h6 class="owner-title mb-3">
                                                                                <i
                                                                                    class="fas fa-user-shield me-2"></i>Clinic
                                                                                Owner
                                                                            </h6>
                                                                            @if ($tempDoctorData)
                                                                                <div
                                                                                    class="new-owner alert alert-warning">
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-2">
                                                                                        <i
                                                                                            class="fas fa-exclamation-circle me-2"></i>
                                                                                        <strong>New Doctor
                                                                                            Profile</strong>
                                                                                    </div>
                                                                                    <ul class="list-unstyled mb-0">
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-user-circle me-2"></i>
                                                                                            {{ $tempDoctorData['name'] }}
                                                                                        </li>
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-envelope me-2"></i>
                                                                                            {{ $tempDoctorData['email'] }}
                                                                                        </li>
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-stethoscope me-2"></i>
                                                                                            {{ $tempDoctorData['specialization'] }}
                                                                                        </li>
                                                                                        <li>
                                                                                            <i
                                                                                                class="fas fa-id-card me-2"></i>
                                                                                            <code>{{ $tempDoctorData['license_number'] }}</code>
                                                                                        </li>
                                                                                    </ul>
                                                                                </div>
                                                                            @elseif($selectedOwner)
                                                                                <div
                                                                                    class="existing-owner alert alert-primary">
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-2">
                                                                                        <i
                                                                                            class="fas fa-check-circle me-2"></i>
                                                                                        <strong>Existing Doctor</strong>
                                                                                    </div>
                                                                                    <div class="doctor-profile">
                                                                                        <h5 class="doctor-name mb-2">
                                                                                            {{ $selectedOwner->name }}
                                                                                        </h5>
                                                                                        <div class="doctor-meta">
                                                                                            <div class="mb-2">
                                                                                                <i
                                                                                                    class="fas fa-envelope me-2"></i>
                                                                                                {{ $selectedOwner->email }}
                                                                                            </div>
                                                                                            <div class="mb-2">
                                                                                                <i
                                                                                                    class="fas fa-phone me-2"></i>
                                                                                                {{ $selectedOwner->doctorProfile->phone ?? 'N/A' }}
                                                                                            </div>
                                                                                            <div>
                                                                                                <i
                                                                                                    class="fas fa-certificate me-2"></i>
                                                                                                {{ $selectedOwner->doctorProfile->license_number ?? 'N/A' }}
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            @else
                                                                                <div
                                                                                    class="no-owner alert alert-secondary">
                                                                                    <i
                                                                                        class="fas fa-user-slash me-2"></i>
                                                                                    No owner assigned
                                                                                </div>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Details Cards -->
                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-map-marked-alt me-2"></i>Address
                                                                    Details</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="address-details">
                                                                    <p class="mb-1">{{ $line1 }}</p>
                                                                    @if ($line2)
                                                                        <p class="mb-1">{{ $line2 }}</p>
                                                                    @endif
                                                                    <div class="geo-meta text-muted small mt-2">
                                                                        {{ $city }}, {{ $state }},
                                                                        {{ $country }}
                                                                        - {{ $pincode }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-phone-volume me-2"></i>Contact
                                                                    Information</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                @if (count($contact_numbers) > 0)
                                                                    <ul class="contact-list list-unstyled mb-0">
                                                                        @foreach ($contact_numbers as $number)
                                                                            <li class="d-flex align-items-center mb-2">
                                                                                <i
                                                                                    class="fas fa-phone fa-sm me-2 text-muted"></i>
                                                                                {{ $number }}
                                                                            </li>
                                                                        @endforeach
                                                                    </ul>
                                                                @else
                                                                    <div class="text-muted">No contact numbers added
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-star-of-life me-2"></i>Specialities
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                @if (count($specialities) > 0)
                                                                    <div class="speciality-tags">
                                                                        @foreach ($specialities as $speciality)
                                                                            <span
                                                                                class="badge bg-primary me-1 mb-1">{{ $speciality }}</span>
                                                                        @endforeach
                                                                    </div>
                                                                @else
                                                                    <div class="text-muted">No specialities specified
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>

                                                    @if ($about)
                                                        <div class="col-12">
                                                            <div class="card detail-card">
                                                                <div class="card-header">
                                                                    <h6 class="mb-0"><i
                                                                            class="fas fa-info-circle me-2"></i>About
                                                                        Clinic</h6>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div class="clinic-about">
                                                                        {{ $about }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <!-- Subscription Plan Card -->
                                                    @if ($showPlanSelection || $selectedPlanDetails)
                                                        <div class="col-12">
                                                            <div class="card review-card">
                                                                <div class="card-header bg-transparent">
                                                                    <h5 class="mb-0"><i
                                                                            class="fas fa-credit-card me-2"></i>Subscription
                                                                        Plan
                                                                    </h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    @if ($selectedPlanDetails)
                                                                        <div class="alert alert-primary">
                                                                            <div
                                                                                class="d-flex justify-content-between align-items-center">
                                                                                <div>
                                                                                    <h6 class="mb-1">
                                                                                        {{ $selectedPlanDetails->plan_name }}
                                                                                    </h6>
                                                                                    <div class="text-muted small">
                                                                                        {{ ucfirst($selectedPlanDetails->plan_type) }}
                                                                                        plan •
                                                                                        @if ($selectedPlanDetails->discounted_price)
                                                                                            <span
                                                                                                class="text-danger ms-2">
                                                                                                <s>${{ number_format($selectedPlanDetails->base_price, 2) }}</s>
                                                                                                ${{ number_format($selectedPlanDetails->discounted_price, 2) }}
                                                                                            </span>
                                                                                        @endif
                                                                                    </div>
                                                                                </div>
                                                                                <button
                                                                                    wire:click="togglePlanSelection"
                                                                                    class="btn btn-sm btn-outline-primary">
                                                                                    Change Plan
                                                                                </button>
                                                                            </div>

                                                                            @if ($selectedPlanDetails->description)
                                                                                <div class="mt-3">
                                                                                    <p class="small mb-1">
                                                                                        <strong>Includes:</strong>
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanDetails->description }}
                                                                                    </p>
                                                                                </div>
                                                                            @endif

                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-user-md me-2"></i>
                                                                                        Doctors:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->included_doctors ?? 'Unlimited' }}
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-users me-2"></i>
                                                                                        Staff:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->included_staff ?? 'Unlimited' }}
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-mobile-alt me-2"></i>
                                                                                        Devices:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanDetails->device_limit ?? 'Unlimited' }}
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-database me-2"></i>
                                                                                        Storage:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->storage_limit_gb ?? 'Unlimited' }}
                                                                                        GB
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-video me-2"></i>
                                                                                        Teleconsultation:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->teleconsultation_minutes ?? 'Unlimited' }}
                                                                                        Minutes
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-sms me-2"></i>
                                                                                        SMS:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->sms_limit ?? 'Unlimited' }}
                                                                                        Massages
                                                                                    </p>
                                                                                </div>
                                                                            </div>

                                                                            @if ($selectedPlanDetails->description)
                                                                                <div class="mt-3">
                                                                                    <p class="small mb-1">
                                                                                        <strong>Remains:</strong>
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanDetails->description }}
                                                                                    </p>
                                                                                </div>
                                                                            @endif

                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-user-md me-2"></i>
                                                                                        Doctors:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->included_doctors - $usedLimits['doctors'] }}
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-users me-2"></i>
                                                                                        Staff:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->included_staff - $usedLimits['staffs'] }}
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-mobile-alt me-2"></i>
                                                                                        Devices:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanDetails->device_limit ?? 'Unlimited' }}
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-database me-2"></i>
                                                                                        Storage:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->storage_limit_gb - $usedLimits['storage_limit'] }}
                                                                                        GB
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-video me-2"></i>
                                                                                        Teleconsultation:</p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->teleconsultation_minutes - $usedLimits['teleconsultation_limit'] }}
                                                                                        Minutes
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-sms me-2"></i>
                                                                                        SMS:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        {{ $selectedPlanLimits->sms_limit - $usedLimits['sms_limit'] }}
                                                                                        Messages
                                                                                    </p>
                                                                                </div>
                                                                            </div>

                                                                        </div>
                                                                    @endif

                                                                    @if ($showPlanSelection)
                                                                        <div class="mt-4">
                                                                            <h6 class="mb-3">Select a Plan:</h6>
                                                                            <div class="row">
                                                                                @foreach ($availablePlans as $plan)
                                                                                    <div class="col-md-4 mb-3">
                                                                                        <div class="card plan-card h-100 cursor-pointer {{ $selected_plan_id == $plan->id ? 'border-primary' : '' }}"
                                                                                            wire:click="$set('selected_plan_id', {{ $plan->id }})">
                                                                                            <div class="card-body">
                                                                                                <h5 class="card-title">
                                                                                                    {{ $plan->plan_name }}
                                                                                                </h5>
                                                                                                <h6 class="mb-3">
                                                                                                    ${{ number_format($plan->base_price, 2) }}
                                                                                                    <small
                                                                                                        class="text-muted">/{{ $plan->plan_type }}</small>
                                                                                                </h6>

                                                                                                <ul
                                                                                                    class="list-unstyled small">
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        {{ $plan->max_doctors ?? 'Unlimited' }}
                                                                                                        Doctors
                                                                                                    </li>
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        {{ $plan->max_staff ?? 'Unlimited' }}
                                                                                                        Staff
                                                                                                    </li>
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        {{ $plan->device_limit ?? 'Unlimited' }}
                                                                                                        Devices
                                                                                                    </li>
                                                                                                    @if ($plan->trial_period)
                                                                                                        <li
                                                                                                            class="mb-2">
                                                                                                            <i
                                                                                                                class="fas fa-check-circle text-success me-2"></i>
                                                                                                            {{ $plan->trial_period }}
                                                                                                            day trial
                                                                                                        </li>
                                                                                                    @endif
                                                                                                </ul>

                                                                                                @if ($plan->discounted_price)
                                                                                                    <div
                                                                                                        class="badge bg-danger mb-2">
                                                                                                        Save
                                                                                                        {{ number_format(100 - ($plan->discounted_price / $plan->base_price) * 100, 0) }}%
                                                                                                    </div>
                                                                                                @endif
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                @endforeach
                                                                            </div>

                                                                            <div
                                                                                class="d-flex justify-content-end mt-3">
                                                                                <button
                                                                                    wire:click="togglePlanSelection"
                                                                                    class="btn btn-secondary">
                                                                                    Cancel
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="text-center py-4">
                                                            <p class="text-muted mb-3">No subscription plan selected
                                                            </p>
                                                            <button wire:click="togglePlanSelection"
                                                                class="btn btn-primary">
                                                                <i class="fas fa-plus me-2"></i>Add Subscription Plan
                                                            </button>
                                                        </div>
                                                    @endif

                                                    <!-- Add On Plan Card -->
                                                    @if ($showAddOnSelection || count($selectedAddOnDetails) > 0)
                                                        <div class="col-12">
                                                            <div class="card review-card">
                                                                <div class="card-header bg-transparent">
                                                                    <div class="d-flex justify-content-between mt-3">
                                                                        <h5 class="mb-0"><i
                                                                                class="fas fa-credit-card me-2"></i>All
                                                                            Add On</h5>
                                                                        @if (!$showAddOnSelection)
                                                                            <button wire:click="toggleAddOnSelection"
                                                                                class="btn btn-sm btn-outline-primary">
                                                                                Change Add Ons
                                                                            </button>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                                <div class="card-body">
                                                                    @if ($selectedAddOnDetails)
                                                                        @foreach ($selectedAddOnDetails as $addOn)
                                                                            <div class="alert alert-primary">
                                                                                <div
                                                                                    class="d-flex justify-content-between align-items-center">

                                                                                    <div>
                                                                                        <div>
                                                                                            <h6 class="mb-1">
                                                                                                {{ $addOn->name }}
                                                                                            </h6>
                                                                                        </div>
                                                                                        <div>
                                                                                            <h6>Remaining:
                                                                                                {{ '32' }}
                                                                                            </h6>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="text-muted small">
                                                                                        {{ ucfirst($addOn->resource_type) }}
                                                                                        Add On • Per
                                                                                        {{ $addOn->unit }} Price
                                                                                        ${{ number_format($addOn->price_per_unit, 2) }}
                                                                                    </div>
                                                                                    @if ($addOn->price_per_unit)
                                                                                        <div class="text-muted small">
                                                                                            Total amount •
                                                                                            <span
                                                                                                class="text-danger ms-2">
                                                                                                {{-- <s>${{ number_format($addOn->price_per_unit * $addOn->unit_counts, 2) }}</s> --}}
                                                                                                ${{ number_format($addOn->price_per_unit * $addOn->unit_counts, 2) }}
                                                                                            </span>
                                                                                        </div>
                                                                                    @endif
                                                                                </div>

                                                                                @if ($addOn->description)
                                                                                    <div class="mt-3">
                                                                                        <p class="small mb-1">
                                                                                            <strong>Includes:</strong>
                                                                                        </p>
                                                                                        <p class="small text-muted">
                                                                                            {{ $addOn->description }}
                                                                                        </p>
                                                                                    </div>
                                                                                @endif

                                                                            </div>
                                                                        @endforeach
                                                                    @endif

                                                                    @if ($showAddOnSelection)
                                                                        <div class="mt-4">
                                                                            <h6 class="mb-3">Select an Add On:</h6>
                                                                            <div class="col-md-6">
                                                                                <label class="form-label">Clinic Add On
                                                                                    (Optional)</label>
                                                                                <div class="dropdown">
                                                                                    <!-- Dynamic dropdown button title -->
                                                                                    <button
                                                                                        class="form-select text-start dropdown-toggle"
                                                                                        type="button"
                                                                                        id="addOnDropdown"
                                                                                        data-bs-toggle="dropdown"
                                                                                        aria-expanded="false">
                                                                                        @if (count($selected_add_on_id) > 0)
                                                                                            {{ count($selected_add_on_id) }}
                                                                                            {{ count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons' }}
                                                                                            Selected
                                                                                        @else
                                                                                            -- Select Add Ons --
                                                                                        @endif
                                                                                    </button>

                                                                                    <!-- Checkbox options -->
                                                                                    <ul class="dropdown-menu w-100"
                                                                                        aria-labelledby="addOnDropdown">
                                                                                        @foreach ($availableAddOns as $addOn)
                                                                                            <li>
                                                                                                <div
                                                                                                    class="dropdown-item">
                                                                                                    <input
                                                                                                        type="checkbox"
                                                                                                        wire:model="selected_add_on_id"
                                                                                                        value="{{ $addOn->id }}"
                                                                                                        id="addon-{{ $addOn->id }}"
                                                                                                        wire:change="updateSelectedCount">
                                                                                                    <label
                                                                                                        for="addon-{{ $addOn->id }}"
                                                                                                        class="ms-2">
                                                                                                        {{ $addOn->name }}
                                                                                                        ({{ $addOn->price_per_unit }}/{{ $addOn->resource_type }})
                                                                                                    </label>
                                                                                                </div>
                                                                                            </li>
                                                                                        @endforeach
                                                                                    </ul>
                                                                                </div>

                                                                                <!-- Selected items details -->
                                                                                @if (count($selected_add_on_id) > 0)
                                                                                    <div class="mt-2 small text-muted">
                                                                                        <strong>Selected:</strong>
                                                                                        @foreach ($availableAddOns->whereIn('id', $selected_add_on_id) as $selected)
                                                                                            <span class="d-block">
                                                                                                {{ $selected->name }}
                                                                                                ({{ $selected->resource_type }})
                                                                                            </span>
                                                                                        @endforeach
                                                                                    </div>
                                                                                @endif
                                                                            </div>

                                                                            <div
                                                                                class="d-flex justify-content-between mt-3">
                                                                                <button
                                                                                    wire:click="toggleAddOnSelection"
                                                                                    class="btn btn-success">
                                                                                    Done
                                                                                </button>
                                                                                <button
                                                                                    wire:click="toggleAddOnSelection"
                                                                                    class="btn btn-secondary">
                                                                                    Cancel
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="text-center py-4">
                                                            <p class="text-muted mb-3">No Add On's selected
                                                            </p>
                                                            <button wire:click="toggleAddOnSelection"
                                                                class="btn btn-primary">
                                                                <i class="fas fa-plus me-2"></i>Add Add On
                                                            </button>
                                                        </div>
                                                    @endif

                                                    <!-- Action Buttons -->
                                                    <div class="col-12">
                                                        <div
                                                            class="form-actions d-flex justify-content-between border-top pt-4">
                                                            <button wire:click="previousStep" type="button"
                                                                class="btn btn-secondary">
                                                                <i class="fas fa-arrow-left me-2"></i>Back
                                                            </button>
                                                            <button wire:click="save" type="button"
                                                                class="btn btn-success">
                                                                {{ isset($clinic) && $clinic->exists ? 'Update Clinic' : 'Create Clinic' }}
                                                                <i class="fas fa-save ms-2"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
    <style>
        .review-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.08);
        }

        .detail-card {
            height: 100%;
            border-radius: 0.75rem;
            transition: transform 0.2s;
        }

        .detail-card:hover {
            transform: translateY(-3px);
        }

        .clinic-name {
            font-weight: 600;
            color: #2c3e50;
        }

        .owner-card .alert {
            border-radius: 0.75rem;
            border: none;
        }

        .speciality-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .doctor-name {
            font-weight: 500;
            color: #34495e;
        }

        .form-actions {
            padding-top: 2rem;
        }

        .clinic-about {
            line-height: 1.6;
            color: #4a5568;
        }

        .contact-list li {
            padding: 0.25rem 0;
        }

        .plan-card {
            transition: all 0.2s ease;
            border: 1px solid #e9ecef;
            border-radius: 0.75rem;
        }

        .plan-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
        }

        .plan-card.border-primary {
            border: 2px solid #2B7F75;
            background-color: rgba(43, 127, 117, 0.03);
        }

        .cursor-pointer {
            cursor: pointer;
        }
    </style>
@endpush
@push('scripts')
    <script src="{{ asset('assets/js/form-wizard.js') }}"></script>
@endpush

