@if (Auth::guard('superadmin')->check())
    <!-- Search Modal -->
    <div class="modal fade" id="searchModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-transparent">
                <div class="card shadow-none mb-0">
                    <div class="px-3 py-2 d-flex flex-row align-items-center" id="search-top">
                        <i class="ti ti-search fs-22"></i>
                        <input type="search" class="form-control border-0" placeholder="Search">
                        <button type="button" class="btn p-0" data-bs-dismiss="modal" aria-label="Close"><i
                                class="ti ti-x fs-22"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif

<div class="sidebar" id="sidebar">
    <div class="sidebar-logo">
        <div>
            <a href="{{ route('admin.dashboard') }}" class="logo logo-normal">
                <img src="{{ asset('assets/img/PRED_CARE-Logo.png') }}" alt="PredCare Logo">
            </a>

            <a href="{{ route('admin.dashboard') }}" class="logo-small">
                <img src="{{ asset('assets/img/PRED_CARE-Logo.png') }}" alt="PredCare Logo">
            </a>

            <a href="{{ route('admin.dashboard') }}" class="dark-logo">
                <img src="{{ asset('assets/img/PRED_CARE-Logo_white.png') }}" alt="PredCare Logo">
            </a>

            <a href="{{ route('admin.dashboard') }}" class="logo-small dark-logo">
                <img src="{{ asset('assets/img/PRED_CARE-Logo_white.png') }}" alt="PredCare Logo">
            </a>
        </div>
        <button class="sidenav-toggle-btn btn border-0 p-0" id="toggle_btn">
            <i class="ti ti-arrow-left"></i>
        </button>
        <button class="sidebar-close">
            <i class="ti ti-x align-middle"></i>
        </button>
    </div>
    <!-- End Logo -->

    <!-- Sidenav Menu -->
    <div class="sidebar-inner" data-simplebar>
        <div id="sidebar-menu" class="sidebar-menu">

            @if (Auth::guard('superadmin')->check())
                <ul>
                    <li>
                        <ul>
                            <li class="{{ Route::is('admin.dashboard') ? 'active' : '' }}">
                                <a href="{{ route('admin.dashboard') }}">
                                    <i class="ti ti-layout-dashboard"></i><span>Dashboard</span>
                                </a>

                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.clinics.index', 'admin.clinics.create', 'admin.clinics.edit', 'admin.clinics.view') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-building-hospital"></i><span>Clinics</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li><a href="{{ route('admin.clinics.index') }}"
                                            class="{{ Route::is('admin.clinics.index', 'admin.clinics.edit', 'admin.clinics.view') ? 'active' : '' }}">Clinics
                                            List</a>
                                    </li>
                                    <li><a href="{{ route('admin.clinics.create') }}"
                                            class="{{ Route::is('admin.clinics.create') ? 'active' : '' }}">
                                            Add Clinic</a></li>
                                </ul>
                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.doctor-management', 'admin.doctor-management.create', 'admin.doctor-management.edit', 'admin.doctor-management.view') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-user-plus"></i><span>Doctors</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li><a href="{{ route('admin.doctor-management') }}"
                                            class="{{ Route::is('admin.doctor-management', 'admin.doctor-management.edit', 'admin.doctor-management.view') ? 'active' : '' }}">Doctors
                                            List</a>
                                    </li>
                                    <li><a href="{{ route('admin.doctor-management.create') }}"
                                            class="{{ Route::is('admin.doctor-management.create') ? 'active' : '' }}">
                                            Add Doctor</a></li>
                                </ul>
                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.staff-list', 'admin.staff-management.create', 'admin.staff-management.edit', 'admin.staff-management.view') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-user-cog"></i><span>Staffs</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li><a href="{{ route('admin.staff-list') }}"
                                            class="{{ Route::is('admin.staff-list') ? 'active' : '' }}">Staff List</a>
                                    </li>
                                    <li><a href="{{ route('admin.staff-management.create') }}"
                                            class="{{ Route::is('admin.staff-management.create') ? 'active' : '' }}">
                                            Add Staff</a></li>
                                </ul>
                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.patient-management', 'admin.patient-list', 'admin.patient-management.create', 'admin.patient-management.edit') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-user-heart"></i><span>Patients</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li><a href="{{ route('admin.patient-list') }}"
                                            class="{{ Route::is('admin.patient-list') ? 'active' : '' }}">Patients
                                            List</a>
                                    </li>
                                    <li><a href="{{ route('admin.patient-management') }}"
                                            class="{{ Route::is('admin.patient-management', 'admin.patient-management.create', 'admin.patient-management.edit') ? 'active' : '' }}">Add
                                            Patient</a></li>
                                </ul>
                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.appointment-list', 'admin.appointment.create', 'admin.appointment.edit') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-calendar"></i><span>Appointments</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li>
                                        <a href="{{ route('admin.appointment-list') }}"
                                            class="{{ Route::is('admin.appointment-list') ? 'active' : '' }}">
                                            Appointment List
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('admin.appointment.create') }}"
                                            class="{{ Route::is('admin.appointment.create', 'admin.appointment.edit') ? 'active' : '' }}">
                                            New Appointment
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is(
                                        'admin.plans.usage-types.index',
                                        'admin.plans.usage-types.create',
                                        'admin.plans.usage-types.edit',
                                        'admin.plans.features.index',
                                        'admin.plans.features.create',
                                        'admin.plans.features.edit',
                                        'admin.plans.addons.index',
                                        'admin.plans.addons.create',
                                        'admin.plans.addons.edit',
                                        'admin.subscription-plans',
                                        'admin.subscription-plans.list',
                                        'admin.subscription-plans.show',
                                        'admin.subscription-plans.edit',
                                    )
                                        ? 'active subdrop'
                                        : '' }}">
                                    <i class="ti ti-credit-card"></i><span>Plan</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li class='submenu submenu-two'>
                                        <a href="javascript:void(0);"
                                            class="{{ Route::is('admin.plans.features.index', 'admin.plans.features.create', 'admin.plans.features.edit')
                                                ? 'active subdrop'
                                                : '' }}">
                                            <i class="ti ti-layout-grid"></i><span>Feature</span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <ul>
                                            <li>
                                                <a href="{{ route('admin.plans.features.index') }}"
                                                    class="{{ Route::is('admin.plans.features.edit', 'admin.plans.features.index') ? 'active' : '' }}">
                                                    Features List</a>
                                            </li>
                                            <li>
                                                <a href="{{ route('admin.plans.features.create') }}"
                                                    class="{{ Route::is('admin.plans.features.create') ? 'active' : '' }}">Add
                                                    Feature</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class='submenu submenu-two'>
                                        <a href="javascript:void(0);"
                                            class="{{ Route::is('admin.plans.usage-types.index', 'admin.plans.usage-types.create', 'admin.plans.usage-types.edit')
                                                ? 'active subdrop'
                                                : '' }}">
                                            <i class="ti ti-chart-bar"></i><span>Usage Type</span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <ul>
                                            <li>
                                                <a href="{{ route('admin.plans.usage-types.index') }}"
                                                    class="{{ Route::is('admin.plans.usage-types.edit', 'admin.plans.usage-types.index') ? 'active' : '' }}">
                                                    Usage Type List</a>
                                            </li>
                                            <li>
                                                <a href="{{ route('admin.plans.usage-types.create') }}"
                                                    class="{{ Route::is('admin.plans.usage-types.create') ? 'active' : '' }}">Add
                                                    Usage Type</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class='submenu submenu-two'>
                                        <a href="javascript:void(0);"
                                            class="{{ Route::is('admin.plans.addons.index', 'admin.plans.addons.create', 'admin.plans.addons.edit')
                                                ? 'active subdrop'
                                                : '' }}">
                                            <i class="ti ti-puzzle"></i><span>Add Ons</span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <ul>
                                            <li>
                                                <a href="{{ route('admin.plans.addons.index') }}"
                                                    class="{{ Route::is('admin.plans.addons.edit', 'admin.plans.addons.index') ? 'active' : '' }}">
                                                    AddOns List</a>
                                            </li>
                                            <li>
                                                <a href="{{ route('admin.plans.addons.create') }}"
                                                    class="{{ Route::is('admin.plans.addons.create') ? 'active' : '' }}">Add
                                                    AddOn</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class='submenu submenu-two'>
                                        <a href="javascript:void(0);"
                                            class="{{ Route::is(
                                                'admin.subscription-plans.list',
                                                'admin.subscription-plans.create',
                                                'admin.subscription-plans.edit',
                                                'admin.subscription-plans',
                                            )
                                                ? 'active subdrop'
                                                : '' }}">
                                            <i class="ti ti-credit-card"></i><span>Subscription Plan</span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <ul>
                                            <li>
                                                <a href="{{ route('admin.subscription-plans.list') }}"
                                                    class="{{ Route::is('admin.subscription-plans.edit', 'admin.subscription-plans.list', 'admin.subscription-plans.show') ? 'active' : '' }}">
                                                    Subscription Plan List</a>
                                            </li>
                                            <li>
                                                <a href="{{ route('admin.subscription-plans') }}"
                                                    class="{{ Route::is('admin.subscription-plans') ? 'active' : '' }}">Add
                                                    Subscription Plan</a>
                                            </li>
                                        </ul>
                                    </li>


                                </ul>
                            </li>
                            <li class="{{ Route::is('admin.specialization-index') ? 'active' : '' }}">
                                <a href="{{ route('admin.specialization-index') }}">
                                    <i class="fas fa-hospital"></i><span>Specializations</span>
                                </a>
                            </li>

                            <li class="submenu submenu-two">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.patient-terms', 'admin.doctor-terms') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-file-description"></i><span>Terms & Conditions</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li>
                                        <a href="{{ route('admin.patient-terms') }}"
                                            class="{{ Route::is('admin.patient-terms') ? 'active' : '' }}">
                                            Patient Terms</a>
                                    </li>
                                    <li>
                                        <a href="{{ route('admin.doctor-terms') }}"
                                            class="{{ Route::is('admin.doctor-terms') ? 'active' : '' }}">
                                            Doctor Terms</a>
                                    </li>
                                </ul>
                            </li>

                            <li class="submenu submenu-two">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.patient-privacy', 'admin.doctor-privacy') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-shield-lock"></i><span>Privacy Policy</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li>
                                        <a href="{{ route('admin.patient-privacy') }}"
                                            class="{{ Route::is('admin.patient-privacy') ? 'active' : '' }}">
                                            Patient Privacy</a>
                                    </li>
                                    <li>
                                        <a href="{{ route('admin.doctor-privacy') }}"
                                            class="{{ Route::is('admin.doctor-privacy') ? 'active' : '' }}">
                                            Doctor Privacy</a>
                                    </li>
                                </ul>
                            </li>

                            <li class="submenu submenu-two">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('admin.patient-faq', 'admin.doctor-faq') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-help-circle"></i><span>FAQ's</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li>
                                        <a href="{{ route('admin.patient-faq') }}"
                                            class="{{ Route::is('admin.patient-faq') ? 'active' : '' }}">
                                            Patient FAQ</a>
                                    </li>
                                    <li>
                                        <a href="{{ route('admin.doctor-faq') }}"
                                            class="{{ Route::is('admin.doctor-faq') ? 'active' : '' }}">
                                            Doctor FAQ</a>
                                    </li>
                                </ul>
                            </li>

                            <li class="{{ Route::is('admin.notification') ? 'active' : '' }}">
                                <a href="{{ route('admin.notification') }}">
                                    <i class="ti ti-bell"></i><span>Notification</span>
                                </a>
                            </li>

                            <li class="{{ Route::is('admin.track-device') ? 'active' : '' }}">
                                <a href="{{ route('admin.track-device') }}">
                                    <i class="ti ti-devices"></i><span>Active Device</span>
                                </a>
                            </li>
                            {{-- <li class="submenu">
                                <a href="javascript:void(0);"
                                    class="{{ Route::is('appointments', 'appointment-consultations', 'new-appointment', 'appointment-calendar') ? 'active subdrop' : '' }}">
                                    <i class="ti ti-calendar-check"></i><span>Appointments</span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul>
                                    <li><a href="{{ route('appointments') }}"
                                            class="{{ Route::is('appointments', 'appointment-consultations') ? 'active' : '' }}">Appointments</a>
                                    </li>
                                    <li><a href="{{ route('new-appointment') }}"
                                            class="{{ Route::is('new-appointment') ? 'active' : '' }}">New
                                            Appointment</a></li>
                                    <li><a href="{{ route('appointment-calendar') }}"
                                            class="{{ Route::is('appointment-calendar') ? 'active' : '' }}">Calendar</a>
                                    </li>
                                </ul>
                            </li> --}}
                        </ul>
                    </li>
                </ul>
            @endif

        </div>
        <div class="sidebar-footer border-top mt-3">
            {{--             <div class="trial-item mt-0 p-3 text-center">
                <div class="trial-item-icon rounded-4 mb-3 p-2 text-center shadow-sm d-inline-flex">
                    <img src="{{ URL::asset('assets/img/icons/sidebar-icon.svg') }}" alt="img">
                </div>
                <div>
                    <h6 class="fs-14 fw-semibold mb-1">Upgrade To Pro</h6>
                    <p class="fs-13 mb-0">Check 1 min video and begin use Preclinic like a pro</p>
                </div>
                <a href="javascript:void(0);" class="close-icon shadow-sm"><i class="ti ti-x"></i></a>
            </div> --}}
        </div>
    </div>

</div>
<!-- Sidenav Menu End -->
