@extends('layouts.app')

@section('title', 'Appointment Create')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>
<!-- Start Content -->
<div class="content">

    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('doctor.appointments.list') }}" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i>Appointments
                    </a>
                </h6>
            </div>
            <!-- page header end -->

            <form method="POST" action="{{ route('doctor.appointments.store') }}">
                @csrf
                <!-- card start -->
                <div class="card">
                    <div class="card-body">
                        <div class="form">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <input type="hidden" id="clinic_id" name="clinic_id" value="{{ $clinicRecord->clinic_id }}">
                                        <label for="specialization_name" class="form-label mb-1 fw-medium">Doctor Specialization / Department<span class="text-danger ms-1">*</span></label>
                                        
                                        <select name="specialization_name" id="specialization_name" class="form-control select2" required>
                                            <option value="">-- Select Specialization --</option>
                                            @foreach($specializations as $spec)
                                                <option value="{{ $spec }}">{{ $spec }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="doctor_id"  class="form-label mb-1 fw-medium">Doctor<span class="text-danger ms-1">*</span></label>
                                        <!-- Doctor dropdown (initially empty) -->
                                        <select name="doctor_id" id="doctor_id" class="form-control select2" required>
                                            <option value="">Select Doctor</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="doctor_specialization" class="form-label mb-1 fw-medium">Doctor Specialization / Department<span class="text-danger ms-1">*</span></label>
                                        <select name="specialization" id="doctor_specialization" class="form-control select2">
                                            <option value="">Select</option>
                                        </select>
                                    </div>
                                </div> -->
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <!-- <label class="form-label mb-1 fw-medium">Booking Date (Appointment)<span class="text-danger ms-1">*</span></label>
                                        <div class="input-icon-end position-relative">  
                                            <input type="text" name="appointment_date" id="appointment_date" class="form-control datetimepicker" placeholder="dd/mm/yyyy" required>
                                            <span class="input-icon-addon">
                                                <i class="ti ti-calendar"></i>
                                            </span>
                                        </div> -->
                                        <label class="form-label mb-1 fw-medium">Booking Date (Appointment)<span class="text-danger ms-1">*</span></label>
                                        <div class="input-icon-end position-relative">  
                                            <input type="text" name="appointment_date" id="appointment_date" class="form-control" placeholder="dd/mm/yyyy" required disabled>
                                            <span class="input-icon-addon">
                                                <i class="ti ti-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium">Available Time Slots</label>
                                        <div id="slot_container">
                                            <p class="text-muted">Please Select Date</p>
                                        </div>
                                        <input type="hidden" id="selected_slot_input" name="appointment_slot_time">
                                        <input type="hidden" name="appointment_time" id="appointment_time">
                                        <!-- <label for="appointment_time" class="form-label mb-1 fw-medium">Doctor's Time Slots:<span class="text-danger ms-1">*</span></label>
                                        <div class="d-flex align-items-center flex-wrap gap-2">
                                            <a href="#" class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">12:30 - 01:30 </a>
                                            <a href="#" class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">01:30 - 02:30</a>
                                            <a href="#" class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">02:30 - 03:30</a>
                                        </div> -->
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <div class="d-flex align-items-center justify-content-between mb-1">
                                            <label class="form-label mb-0 fw-medium">Patient<span class="text-danger ms-1">*</span></label>
                                            <a href="javascript:void(0);" class="link-primary" data-bs-toggle="modal" data-bs-target="#add_modal"><i class="ti ti-circle-plus me-1"></i>Add New</a>
                                        </div>
                                        <select name="patient_id" class="form-control select2">
                                            <option value="">Select Patient</option>
                                            @foreach ($patients as $patient)
                                                <option value="{{ $patient->id }}">{{ $patient->name }} - ({{ $patient->id }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="appointment_type" class="form-label d-block">Appointment Fee<span class="text-danger ms-1">*</span></label>
                                        <!-- <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="in_person_fee" id="in_person_fee" value="250" required>
                                            <label class="form-check-label" for="in_person_fee">In-Person Fee - 250</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="video_fee" id="video_fee" value="450" required>
                                            <label class="form-check-label" for="video_fee">Video Fee - 450</label>
                                        </div> -->
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="consultation_fee" data-fee-type="in_person_fee" id="in_person_fee" value="" required>
                                            <label class="form-check-label" for="in_person_fee">In-Person Fee</label>
                                        </div>

                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="consultation_fee" data-fee-type="video_fee" id="video_fee" value="" required>
                                            <label class="form-check-label" for="video_fee">Video Fee</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="mb-3">
                                        <label for="total_price">Total Price:</label>
                                        <input type="text" id="total_price" name="total_price" class="form-control">
                                        <input type="hidden" name="fee_type" id="fee_type">

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="appointment_type" class="form-label mb-1 fw-medium">Appointment Status<span class="text-danger ms-1">*</span></label>
                                        <select name="appointment_status" id="appointment_status" class="form-control select2" required>
                                            <option value="">-- Select Status --</option>
                                            <!-- <option value="pending">Pending</option>  
                                            <option value="confirmed">Confirmed</option>  
                                            <option value="Completed">Completed</option>   -->
                                            <option value="cancelled">Cancelled</option>
                                            <option value="online">Online</option>  
                                            <option value="offline">Offline</option>   
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="appointment_type" class="form-label mb-1 fw-medium">Appointment Type<span class="text-danger ms-1">*</span></label>
                                        <select name="appointment_type" id="appointment_type" class="form-control select2" required>
                                            <option value="">-- Select Type --</option>
                                            <option value="first_visit">First visit</option> 
                                            <option value="follow_up">Follow up</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-0">
                                        <label class="form-label mb-1 fw-medium">Reason of visit<span class="text-danger ms-1">*</span></label>
                                        <textarea name="reason" id="reason" class="form-control" rows="3" required></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- card end -->

                <div class="d-flex align-items-center justify-content-end mt-3">
                    <a href="{{ route('doctor.appointments.list') }}" class="btn btn-light me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Create Appointment
                    </button>
                </div>
            </form>

        </div>
    </div>
    <!-- row end -->   
     
</div>
<!-- End Content -->

@if(session('success'))
    <script>
        notyf.success("{{ session('success') }}");
    </script>
@endif

@if(session('error'))
    <script>   
        notyf.error("{{ session('error') }}");
    </script>
@endif


<!-- Start Add modal -->
    <div class="modal fade" id="add_modal">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-dark fw-bold">Add New Patient</h5>
                    <button type="button" class="btn-close custom-btn-close opacity-100" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-x bg-white fs-16 text-dark"></i></button>
                </div>

                <form action="{{ route('doctor.appointments.patientsstore') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body pb-0">
                        <div class="form">
                            <h6 class="fw-bold mb-3">Patient Information</h6>
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="mb-3 d-flex align-items-center">
                                        <label class="form-label mb-0">Profile Image</label>
                                        <div class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">
                                            <i class="ti ti-user-plus fs-16"></i>
                                            <input type="file" name="profile_image" class="form-control image-sign">
                                            <div class="position-absolute bottom-0 end-0 star-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center z-n1">
                                                <a href="javascript:void(0);" class="text-white d-flex align-items-center justify-content-center">
                                                    <i class="ti ti-photo fs-14"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Doctor selection --}}
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <input type="hidden" id="clinic_id" name="clinic_id" value="{{ $clinicRecord->clinic_id }}">
                                        <label class="form-label mb-1 fw-medium">Assign Doctor<span class="text-danger ms-1">*</span></label>
                                        <select id="doctor_id" name="doctor_id" class="form-control select2" required>
                                            <option value="">Select Doctor</option>
                                            <option value="{{ $loggedInDoctor->id }}">
                                                {{ $loggedInDoctor->name }} - (You)
                                            </option>
                                            @foreach ($otherDoctors as $doctor)
                                                <option value="{{ $doctor->id }}">
                                                    {{ $doctor->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                {{-- Patient fields --}}
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Full Name<span class="text-danger">*</span></label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter the name" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email<span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control" placeholder="Enter the email" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Password<span class="text-danger">*</span></label>
                                        <input type="password" name="password" class="form-control" placeholder="***********" >
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Confirm Password</label>
                                        <input type="password" name="password_confirmation" class="form-control" placeholder="***********" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Phone<span class="text-danger">*</span></label>
                                        <input type="tel" id="phone" name="phone" class="form-control" placeholder="Enter the number" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">DOB<span class="text-danger">*</span></label>
                                        <input type="date" name="date_of_birth" class="form-control" placeholder="Enter date" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Gender<span class="text-danger">*</span></label>
                                        <select name="gender" class="form-control" required>
                                            <option value="">Select</option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Status<span class="text-danger">*</span></label>
                                        <select name="status" class="form-control" required>
                                            <option value="">Select</option>
                                            <option value="Active">Active</option>
                                            <option value="Inactive">Inactive</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label">Medical History</label>
                                        <textarea name="medical_history" class="form-control" rows="3" placeholder="Enter patient's medical history"></textarea>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label">Additional Notes</label>
                                        <textarea name="notes" class="form-control" rows="2" placeholder="Write additional notes"></textarea>
                                    </div>
                                </div>
                            </div>

                            <h6 class="fw-bold mb-3 border-top pt-3 form-label">Address Information</h6>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label>Address<span class="text-danger">*</span></label>
                                        <textarea name="address" class="form-control" placeholder="Enter the address" required></textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light btn-sm me-2" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary btn-sm">Add New Patient</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Add modal  -->


<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<!-- AJax Based fecth the specialization and time slots -->
<input type="hidden" id="getSpecializationRoute" value="{{ route('doctor.appointments.getSpecialization', ['id' => 'doctor_id']) }}">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function () {

        // STEP 1: On Specialization Change → Load Doctors
        $(document).ready(function () {
            $('#specialization_name').on('change', function () {
                var specialization = $(this).val();
                var doctorSelect = $('#doctor_id');

                doctorSelect.empty(); // Clear previous options

                if (specialization) {
                    $.ajax({
                        //url: '{{ url("doctor/appointments-management/get-doctors-by-specialization-name") }}/' + encodeURIComponent(specialization),
                        //url: '{{ url("doctor.appointments.get-doctors-by-specialization-name") }}/' + encodeURIComponent(specialization),
                        url: '{{ route("doctor.appointments.getDoctorsBySpecializationName", ":name") }}'.replace(':name', encodeURIComponent(specialization)),

                        method: 'GET',
                        success: function (response) {
                            if (response.status === 'success') {
                                doctorSelect.append('<option value="">Select Doctor</option>');
                                response.data.forEach(function (doctor) {
                                    doctorSelect.append('<option value="' + doctor.id + '">' + doctor.name + ' - (' + doctor.id + ')</option>');
                                });
                            } else {
                                doctorSelect.append('<option value="">No doctors found</option>');
                            }
                        },
                        error: function () {
                            doctorSelect.append('<option value="">Error fetching doctors</option>');
                        }
                    });
                }
            });
        });

        // STEP 2: On Doctor Change → Load Specialization and Time Slots
        $('#doctor_id').on('change', function () {

            // Doctor Specialization
            var selectedDoctorId = $(this).val();
            var specializationSelect = $('#doctor_specialization');

            specializationSelect.empty(); // Clear previous options

            if (selectedDoctorId) {
                $.ajax({
                    url: '{{ url("doctor/appointments-management/get-doctor-specialization") }}/' + selectedDoctorId,
                    method: 'GET',
                    success: function (response) {
                        if (response.status === 'success' && response.data.length > 0) {
                            specializationSelect.append('<option value="">Select</option>');
                            response.data.forEach(function (item) {
                                specializationSelect.append('<option value="' + item + '">' + item + '</option>');
                            });
                        } else {
                            specializationSelect.append('<option value="">' + response.message + '</option>');
                        }
                    },
                    error: function () {
                        specializationSelect.append('<option value="">Error fetching specialization</option>');
                    }
                });
            }

            // Doctor Time Slot 
            let doctorId = $(this).val();
            if (doctorId) {
                // $.ajax({
                //     url: '{{ route("doctor.appointments.getAvailability", ":id") }}'.replace(':id', doctorId),
                //     type: 'GET',
                //     success: function (response) {
                //         let container = $('#time-slots-container');
                //         container.empty();

                //         if (response.success) {
                //             response.slots.forEach(function (slot) {
                //                 container.append(`
                //                     <a href="#" class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">
                //                         ${slot}
                //                     </a>
                //                 `);
                //             });
                //         } else {
                //             container.html('<span class="text-danger">No availability found</span>');
                //         }
                //     }
                // });
            
                // Fee Structure 
                $.ajax({
                    url: '{{ route("doctor.appointments.getFee", ":id") }}'.replace(':id', doctorId),
                    type: 'GET',
                    success: function (response) {
                        if (response.success) {
                            // ✅ Set In-Person and Video Fees
                            $('#in_person_fee').val(response.in_person_fee);
                            $('label[for="in_person_fee"]').text('In-Person Fee - ' + response.in_person_fee);

                            $('#video_fee').val(response.video_fee);
                            $('label[for="video_fee"]').text('Video Fee - ' + response.video_fee);
                        } else {
                            console.error('Fee fetch failed:', response.message);
                        }
                    },
                    error: function (xhr) {
                        console.error('Error fetching fees:', xhr.responseText);
                    }
                });
            }

        });
    });


    // Multiple Time Slot Select Script 
    let allowMultipleSelection = true; // change to false for single selection
    $(document).on('click', '#time-slots-container a', function (e) {
        e.preventDefault();

        if (!allowMultipleSelection) {
            $('#time-slots-container a').removeClass('bg-success text-white').addClass('bg-light text-dark');
        }

        $(this).toggleClass('bg-success text-white').toggleClass('bg-light text-dark');

        // Collect selected slots
        let selectedSlots = [];
        $('#time-slots-container a.bg-success').each(function () {
            selectedSlots.push($(this).text().trim());
        });

        $('#appointment_time').val(selectedSlots.join(', '));
    });
</script>
<script>
    $(document).ready(function () {
        // Initialize Flatpickr with basic options
        const datePicker = flatpickr("#appointment_date", {
            dateFormat: "d/m/Y",
            minDate: "today", // Disable past dates
            disableMobile: true // Force desktop view on mobile too (optional)
        });

        // Initially disable the input
        $('#appointment_date').prop('disabled', true);

        // On doctor selection
        $('#doctor_id').on('change', function () {
            const doctorId = $(this).val();

            if (doctorId) {
                // Enable input
                $('#appointment_date').prop('disabled', false);

                // Set today's date
                // const today = new Date();
                // const formattedDate = String(today.getDate()).padStart(2, '0') + '/' +
                //                       String(today.getMonth() + 1).padStart(2, '0') + '/' +
                //                       today.getFullYear();
                // $('#appointment_date').val(formattedDate);
                datePicker.setDate(today); // Update Flatpickr selected date
            } else {
                $('#appointment_date').val('').prop('disabled', true);
            }
        });
    });
</script>

<script>
$('#doctor_id, #appointment_date').on('change', function () {
    const doctorId = $('#doctor_id').val();
    const selectedDate = $('#appointment_date').val(); // Already in YYYY-MM-DD
    fetchDoctorSlots(doctorId, selectedDate);
});
</script>

<script>
function fetchDoctorSlots(doctorId, selectedDate) {
    const container = $('#slot_container');
    container.empty();

    if (selectedDate.includes('/')) {
        const parts = selectedDate.split('/');
        if (parts.length === 3) {
            selectedDate = `${parts[2]}-${parts[1].padStart(2, '0')}-${parts[0].padStart(2, '0')}`;
        }
    }

    if (!doctorId || !selectedDate) {
        container.html('<p class="text-muted">Please select doctor and date</p>');
        return;
    }

    const url = '{{ route("doctor.appointments.getSlots", ":id") }}'.replace(':id', doctorId) + '?date=' + selectedDate;
    container.html('<p class="text-muted">Loading slots...</p>');

    $.ajax({
        url: url,
        type: 'GET',
        success: function (response) {
            container.empty(); // clear loading message

            if (response.success) {
                const slots = response.slots;
                $('#selected_slot_input').val(''); // Clear hidden input

                if (slots.length === 0) {
                    container.html('<span class="text-danger">No available time slots</span>');
                    return;
                }

                slots.forEach(slot => {
                    if (slot.status === 'booked') {
                        container.append(`
                            <a href="javascript:void(0);" class="d-inline-flex align-items-center bg-light text-success border border-success rounded flex-fill text-center justify-content-center px-3 py-1 m-1 disabled" style="cursor: not-allowed; pointer-events: none;">
                                <i class="fas fa-check-square text-success"></i>&nbsp; ${slot.time}
                            </a>

                        `);
                    } else {
                        container.append(`
                            <a href="javascript:void(0);" class="d-inline-flex align-items-center bg-light text-dark border rounded flex-fill text-center justify-content-center px-3 py-1 m-1 slot-select" data-time="${slot.time}">
                                <i class="far fa-clock"></i>&nbsp; ${slot.time}
                            </a>
                        `);
                    }
                });

                // handle multi-select
                let selectedSlots = [];
                $('.slot-select').off('click').on('click', function () {
                    const time = $(this).data('time');
                    const index = selectedSlots.indexOf(time);

                    if (index === -1) {
                        selectedSlots.push(time);
                        $(this).removeClass('bg-light text-dark').addClass('bg-primary text-white');
                    } else {
                        selectedSlots.splice(index, 1);
                        $(this).removeClass('bg-primary text-white').addClass('bg-light text-dark');
                    }

                    $('#selected_slot_input').val(selectedSlots.join(','));
                });

            } else {
                container.html(`<span class="text-danger">${response.message}</span>`);
            }
        },
        error: function () {
            container.html('<span class="text-danger">Something went wrong. Please try again later.</span>');
        }
    });
}
</script>

<script>
    // function calculateTotalPrice() {
    //     // Get slot input value by name
    //     const slotInput = document.getElementsByName('appointment_slot_time')[0];
    //     const slotValue = slotInput.value.trim();
    //     const slotCount = slotValue ? slotValue.split(',').length : 0;

    //     // Get selected fee by name
    //     const feeRadios = document.getElementsByName('consultation_fee');
    //     let selectedFee = 0;
    //     for (let i = 0; i < feeRadios.length; i++) {
    //         if (feeRadios[i].checked) {
    //             selectedFee = parseFloat(feeRadios[i].value);
    //             break;
    //         }
    //     }

    //     // Calculate total and update total_price input by name
    //     const total = slotCount * selectedFee;
    //     const totalInput = document.getElementsByName('total_price')[0];
    //     totalInput.value = total ? `${total}` : '';
    // }

    // // Add change event to all consultation fee radios
    // const feeRadios = document.getElementsByName('consultation_fee');
    // for (let i = 0; i < feeRadios.length; i++) {
    //     feeRadios[i].addEventListener('change', calculateTotalPrice);
    // }

    // // Optional: recalculate if slot value changes dynamically
    // document.getElementsByName('appointment_slot_time')[0].addEventListener('change', calculateTotalPrice);

    function calculateTotalPrice() {
        const slotInput = document.getElementsByName('appointment_slot_time')[0];
        const slotValue = slotInput.value.trim();
        const slotCount = slotValue ? slotValue.split(',').length : 0;

        const feeRadios = document.getElementsByName('consultation_fee');
        let selectedFee = 0;
        let selectedFeeType = '';

        for (let i = 0; i < feeRadios.length; i++) {
            if (feeRadios[i].checked) {
                selectedFee = parseFloat(feeRadios[i].value);
                selectedFeeType = feeRadios[i].dataset.feeType || '';
                break;
            }
        }

        // Set total price
        const total = slotCount * selectedFee;
        document.getElementsByName('total_price')[0].value = total ? `${total}` : '';

        // Set fee_type value
        document.getElementById('fee_type').value = selectedFeeType;
    }

    // Add event listeners
    const feeRadios = document.getElementsByName('consultation_fee');
    for (let i = 0; i < feeRadios.length; i++) {
        feeRadios[i].addEventListener('change', calculateTotalPrice);
    }
    document.getElementsByName('appointment_slot_time')[0].addEventListener('change', calculateTotalPrice);
</script>

@endsection