<div class="d-flex justify-content-between align-items-center mt-3">
    @if(in_array($position, ['left', 'both']))
        <div class="dataTables_length" id="DataTables_Table_0_length">
            <label>Row Per Page
                <select wire:model.live="perPage" class="form-select form-select-sm">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                Entries
            </label>
        </div>
    @endif

    @if(in_array($position, ['right', 'both']))
        <div class="dataTables_paginate paging_simple_numbers" id="DataTables_Table_0_paginate">
            <ul class="pagination mb-0">
                {{-- Previous Page Link --}}
                <li class="paginate_button page-item previous @if ($paginator->onFirstPage()) disabled @endif">
                    <a wire:click="previousPage" @if ($paginator->onFirstPage()) aria-disabled="true" @endif
                        class="page-link">
                        <i class="ti ti-arrow-left"></i>
                    </a>
                </li>

                {{-- Page Numbers --}}
                @foreach ($paginator->getUrlRange(1, $paginator->lastPage()) as $page => $url)
                    <li class="paginate_button page-item @if ($page == $paginator->currentPage()) active @endif">
                        <a wire:click="gotoPage({{ $page }})" class="page-link">
                            {{ $page }}
                        </a>
                    </li>
                @endforeach

                {{-- Next Page Link --}}
                <li class="paginate_button page-item next @if (!$paginator->hasMorePages()) disabled @endif">
                    <a wire:click="nextPage" @if (!$paginator->hasMorePages()) aria-disabled="true" @endif
                        class="page-link">
                        <i class="ti ti-arrow-right"></i>
                    </a>
                </li>
            </ul>
        </div>
    @endif
</div>