<table class="table">
<thead>
  <tr><th>Date</th><th>Slot</th><th>Action</th></tr>
</thead>
<tbody>
@foreach($appointments as $a)
<tr>
  <td>{{ $a->appointment_date }}</td>
  <td>{{ $a->appointment_slot_time }}</td>
  <td>
    <a href="{{ auth('doctor')->check()
                ? route('doctor.call', ['appointment_id' => $a->id])
                : route('patient.call', ['appointment_id' => $a->id]) }}"
       class="btn btn-primary">Join Call</a>

    <!-- OR, if you prefer AJAX create/fetch then redirect: -->
    <button class="btn btn-secondary join-ajax" data-id="{{ $a->id }}">Join (AJAX)</button>
  </td>
</tr>
@endforeach
</tbody>
</table>

<script>
document.querySelectorAll('.join-ajax').forEach(btn=>{
  btn.addEventListener('click', async function(){
    const appointmentId = this.dataset.id;
    try{
      const res = await fetch('/api/appointment-meeting', {
        method: 'POST',
        headers: {'Content-Type':'application/json','X-CSRF-TOKEN':'{{ csrf_token() }}'},
        body: JSON.stringify({ appointment_id: appointmentId })
      });
      const data = await res.json();
      if (data.status === 'success') {
        window.location.href = `/doctor/call?appointment_id=${appointmentId}`;
        // or redirect to /join/:meetingId if you prefer: window.location.href=`/join/${data.meeting_id}`;
      } else {
        alert('Error: ' + (data.message || 'Unable to create meeting'));
      }
    } catch(err) {
      console.error(err);
      alert('Something went wrong');
    }
  });
});
</script>
