
@extends('layouts.app')

@section('title', 'FAQ')

@section('content')
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>
    <div class="content">
        
        <!-- row start -->
        <div class="row justify-content-center">
            <div class="col-lg-12">

                <!-- page header start -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="{{ route('admin.patient-faq') }}" class="text-dark">
                            <!-- <i class="ti ti-chevron-left me-1"></i> -->
                            {{ 'Frequently Asked Questions (FAQ)' }}
                        </a>
                    </h6>
                </div>
                <!-- page header end -->

                <form action="{{ route('admin.patient-faq.store') }}" method="POST">
                @csrf

                    <!-- card start -->
                    <div class="card">
                        <div class="card-body pb-0">
                            <div id="doctor-form" class="form">

                                <div class="row">
                                    <!-- FAQ -->
                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label for="question" class="form-label">Question</label>
                                            <input type="text" name="question" id="question" class="form-control @error('question') is-invalid @enderror" value="{{ old('question') }}" placeholder="Enter FAQ question here" required>
                                            @error('question') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="answer" class="form-label">Answer</label>
                                            <textarea name="answer" id="answer" rows="4" class="form-control @error('answer') is-invalid @enderror" placeholder="Enter the answer for this FAQ" required>{{ old('answer') }}</textarea>
                                            @error('answer') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="status" class="form-label">Status</label>
                                            <select name="status" class="form-select" required>
                                                <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>Active</option>
                                                <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
            
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- card end -->

                    <div class="d-flex align-items-center justify-content-end">
                        <!-- <button type="button" class="btn btn-light me-2">
                            <i class="ti ti-refresh"></i> Reset Form
                        </button> -->
                        <button type="submit" class="btn btn-primary"><span><i class="ti ti-plus"></i> Add FAQ</span></button>
                    </div>
                </form>

                <!-- Header Text -->
                <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
                    <div class="flex-grow-1">
                        <h6 class="fw-bold mb-0">
                            {{ 'Frequently Asked Questions List' }}
                        </h6>
                    </div>
                </div>

                <!-- Table Start -->
                <div class="table-responsive">
                    <table class="table datatable table-nowrap">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>FAQ Question</th>
                                <th>Answer</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($faqs as $index => $faq)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $faq->question }}</td>
                                    <td style="white-space: normal;">
                                        <div style="white-space: pre-line;">{{ $faq->answer }}</div>
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.patient-faq.toggle-status', $faq->id) }}"
                                        class="badge {{ $faq->status == 'active' ? 'badge-soft-success border border-success' : 'badge-soft-danger border border-danger' }}">
                                        {{ ucfirst($faq->status) }}
                                        </a>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <a href="#" data-bs-toggle="dropdown" class="text-dark">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-end">
                                                <li>
                                                    <a href="{{ route('admin.faq.edit', $faq->id) }}" class="dropdown-item">
                                                        <i class="ti ti-edit me-2"></i> Edit
                                                    </a>
                                                </li>
                                                <li>
                                                    <form action="{{ route('admin.patient-faq.delete', $faq->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="dropdown-item text-danger">
                                                            <i class="ti ti-trash me-2"></i> Delete
                                                        </button>
                                                    </form>
                                                </li>
                                                <li>
                                                    <a href="{{ route('admin.patient-faq.toggle-status', $faq->id) }}" class="dropdown-item {{ $faq->status == 'active' ? 'text-danger' : 'text-success' }}">
                                                        <i class="ti {{ $faq->status == 'active' ? 'ti-ban' : 'ti-check' }} me-2"></i>
                                                        {{ $faq->status === 'active' ? 'Inactivate' : 'Activate' }}
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">No FAQ records found.</td>
                                </tr>
                            @endforelse
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
        <!-- row end -->

    </div>
@endsection
