
@extends('layouts.app')

@section('title', 'Notification')

@section('content')
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>
    <div class="content">
        
        <!-- row start -->
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- page header start -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="{{ route('admin.notification') }}" class="text-dark">
                            <!-- <i class="ti ti-chevron-left me-1"></i> -->
                            {{ 'Notification' }}
                        </a>
                    </h6>
                </div>
                <!-- page header end -->

                <form action="{{ route('admin.notification.store') }}" method="POST">
                    @csrf

                    <!-- card start -->
                    <div class="card">
                        <div class="card-body pb-0">
                            <div id="doctor-form" class="form">

                                <div class="row">
                                    <!-- Bio -->
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="name" class="form-label mb-1 fw-medium">
                                                User Name<span class="text-danger ms-1">*</span>
                                            </label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" placeholder="Enter user's full name" required>
                                            @error('name')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <!-- Notification Title -->
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="title" class="form-label mb-1 fw-medium">
                                                Notification Title<span class="text-danger ms-1">*</span>
                                            </label>
                                            <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" id="title" wire:model="title" placeholder="Enter notification title" required>
                                            @error('title')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <!-- Notification Body -->
                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label for="notification" class="form-label mb-1 fw-medium">Send Notification</label>
                                            <textarea class="form-control @error('notification') is-invalid @enderror" name="message" id="notification" rows="10" wire:model="notification" placeholder="Write the notification message here" required></textarea>
                                            @error('notification')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- card end -->

                    <div class="d-flex align-items-center justify-content-end">
                        <!-- <button type="button" class="btn btn-light me-2">
                            <i class="ti ti-refresh"></i> Reset Form
                        </button> -->
                        <button type="submit" class="btn btn-primary">
                            <span>
                                <i class="ti ti-plus"></i> Add Notification
                            </span>
                            <!-- <span wire:loading>
                                <i class="ti ti-loader fa-spin"></i> Processing...
                            </span> -->
                        </button>
                    </div>
                </form>


                <!-- Header Text -->
                <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
                    <div class="flex-grow-1">
                        <h6 class="fw-bold mb-0">
                            Notifications List
                        </h6>
                    </div>
                </div>

                <!-- Notification Table -->
                <div class="table-responsive">
                    <table class="table datatable table-nowrap">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>User Name</th>
                                <th>Notification Title</th>
                                <th>Message</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($notifications as $index => $note)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $note->name }}</td>
                                    <td>{{ $note->title }}</td>
                                    <td>{{ $note->message }}</td>                      
                                    <td>
                                        <form action="{{ route('admin.notification.delete', $note->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="5" class="text-center">No notifications found.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
@endsection
