@extends('layouts.app')

@section('title', 'Privacy Policy')

@section('content')
<div class="content">
    <div class="row">
        <div class="col-12">
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">Edit Privacy Policy</h6>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> Please fix the following issues:<br><br>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.privacy.update', $policy->id) }}" method="POST">
                @csrf

                <!-- card start -->
                <div class="card">
                    <div class="card-body pb-0">
                        <div id="doctor-form" class="form">

                            <div class="row">
                                <!-- privacy -->
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label for="bio" class="form-label mb-1 fw-medium">Edit Information on Privacy Policy</label>
                                        <textarea class="form-control" name="content" rows="8" required>{{ $policy->content }}</textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status</label>
                                        <select name="status" class="form-select" required>
                                            <option value="active" {{ $policy->status === 'active' ? 'selected' : '' }}>Active</option>
                                            <option value="inactive" {{ $policy->status === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- card end -->

                <div class="text-end">
                    <a href="{{ route('admin.patient-privacy') }}" class="btn btn-warning"><i class="fas fa-times me-1"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update Privacy</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection