@extends('layouts.app')

@section('title', isset($plan) ? 'Edit Plan' : 'Add Plan')

@section('content')
    @if(isset($plan))
        {{-- Edit Mode --}}
        @livewire('admin.subscription-plan-wizard.wizard', [
            'planId' => $plan->id,
            'editing' => true,
            'editingPlanId' => $plan->id
        ], key(['edit', $plan->id]))
    @else
        {{-- Create Mode --}}
        @livewire('admin.subscription-plan-wizard.wizard', [
            'editing' => false
        ], key(['create']))
    @endif
@endsection