@extends('layouts.login-layout')

@section('title', 'Admin Login')

@section('content')
    @livewire('admin.auth.login-form' , ['role' => $role])
    @if (env('SHOW_DEV_NAVBAR'))
        <!-- Development Navbar -->
        <div class="dev-navbar" style="justify-items: center;">
            <strong>Development Login Links:</strong>
            <ul
                style="list-style: none;
                        padding-left: 0;
                        display: flex;
                        gap: 15px;
                        margin: 10px;
                        justify-content: center;">
                <li><a href="{{ route('admin.login') }}" class="btn btn-sm btn-outline-primary">Admin Login</a></li>
                <li><a href="{{ route('doctor.login') }}" class="btn btn-sm btn-outline-primary">Doctor Login</a>
                </li>
                <li><a href="{{ route('patient.login') }}" class="btn btn-sm btn-outline-primary">Patient Login</a>
                </li>
            </ul>
        </div>
    @endif
@endsection