<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Clinic;
use App\Models\Doctor;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ClinicSeeder extends Seeder
{
    public function run()
    {
        DB::transaction(function () {
            $clinics = [
                [
                    'clinic_name' => 'Sunshine Clinic',
                    'clinic_email' => 'contact@sunshine.com',
                    'doctor_email' => 'dr.sunshine@predcare.com',
                    'doctor_name' => 'Dr. Sunny Ray'
                ],
                [
                    'clinic_name' => 'HealthFirst Center',
                    'clinic_email' => 'info@healthfirst.com',
                    'doctor_email' => 'dr.health@predcare.com',
                    'doctor_name' => 'Dr. Clara Health'
                ],
                [
                    'clinic_name' => 'CityCare Hospital',
                    'clinic_email' => 'hello@citycare.com',
                    'doctor_email' => 'dr.city@predcare.com',
                    'doctor_name' => 'Dr. Victor City'
                ]
            ];

            foreach ($clinics as $data) {
                // Owner is separate
                $owner = User::firstOrCreate([
                    'email' => 'owner_' . Str::slug($data['clinic_name']) . '@predcare.com',
                ], [
                    'name' => $data['clinic_name'] . ' Owner',
                    'password' => bcrypt('password'),
                ]);

                // Doctor user
                $doctorUser = User::firstOrCreate([
                    'email' => $data['doctor_email'],
                ], [
                    'name' => $data['doctor_name'],
                    'password' => bcrypt('password'),
                ]);

                // Doctor profile
                Doctor::firstOrCreate([
                    'user_id' => $doctorUser->id,
                ], [
                    'specialization' => 'General Physician',
                    'qualifications' => 'MBBS',
                    'experience_years' => rand(5, 15),
                    'license_number' => strtoupper(Str::random(10)),
                    'bio' => 'Generated for seeding.'
                ]);

                // Clinic
                $clinic = Clinic::create([
                    'name' => $data['clinic_name'],
                    'email' => $data['clinic_email'],
                    'about' => 'Auto-generated clinic for testing.',
                    'line1' => '123 Clinic Street',
                    'city' => 'DemoCity',
                    'state' => 'DemoState',
                    'country' => 'DemoLand',
                    'pincode' => '123456',
                    'location' => ['lat' => 0.0, 'lng' => 0.0],
                    'specialities' => ['General'],
                    'contact_numbers' => ['+10000000000'],
                    'owner_id' => $owner->id,
                ]);

                // Attach doctor
                $clinic->doctors()->attach($doctorUser->id, [
                    'is_primary' => true,
                    'status' => 'active',
                    'in_person_fee' => 100,
                    'video_fee' => 80,
                    'home_visit_fee' => 150,
                    'added_by' => $owner->id,
                    'subscription_member_id' => null
                ]);
            }
        });
    }
}
