<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('doctor_prescriptions', function (Blueprint $table) {
            $table->enum('type', ['doctor', 'patient'])->after('appointment_id')->default('doctor');
        });
    }

    public function down(): void
    {
        Schema::table('doctor_prescriptions', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};

