<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            // doctor_id और patient_id nullable कर दो
            $table->unsignedBigInteger('doctor_id')->nullable()->change();
            $table->unsignedBigInteger('patient_id')->nullable()->change();

            // appointment_id नया column add करो
            $table->unsignedBigInteger('appointment_id')->nullable()->after('doctor_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            $table->dropColumn('appointment_id');

            // rollback में फिर से not null कर दो (जैसा पहले था)
            $table->unsignedBigInteger('doctor_id')->nullable(false)->change();
            $table->unsignedBigInteger('patient_id')->nullable(false)->change();
        });
    }
};
