<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('term_conditions', function (Blueprint $table) {
            $table->enum('type', ['doctor', 'patient'])
                ->default('doctor')
                ->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('term_conditions', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};
