<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // guard करके add कर रहे हैं ताकि duplicate ना हो
        if (! Schema::hasColumn('appointments', 'payment_type')) {
            Schema::table('appointments', function (Blueprint $table) {
                $table->enum('payment_type', ['cash', 'online'])
                      ->default('cash')
                      ->after('appointment_status');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('appointments', 'payment_type')) {
            Schema::table('appointments', function (Blueprint $table) {
                $table->dropColumn('payment_type');
            });
        }
    }
};
