<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->string('appointment_id')->unique();
            $table->unsignedBigInteger('patient_id');
            $table->unsignedBigInteger('doctor_id');
            $table->unsignedInteger('clinic_id');
            $table->string('specialization');
            $table->date('appointment_date');
            $table->json('appointment_slot_time');
            $table->decimal('appointment_fee', 10, 2);
            $table->enum('fee_type', ['in_person_fee', 'video_fee']);
            $table->enum('appointment_type', ['First Visit', 'Follow up']);
            $table->enum('appointment_status', ['Cancelled / Refunded', 'Online', 'Offline', 'Cancelled', 'Refunded']);
            $table->text('reason');
            $table->timestamps();

            $table->foreign('doctor_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('patient_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};

