<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorAvailabilityTable extends Migration
{
    public function up(): void
    {
        Schema::create('doctor_availability', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('clinic_id');
            $table->unsignedBigInteger('doctor_id');
            $table->integer('slot_duration'); // in minutes
            $table->string('day'); // e.g., Monday, Tuesday
            $table->time('from_time');
            $table->time('to_time');
            $table->json('time_slot')->nullable(); // optional: JSON of generated slots
            $table->json('booked_time_slot')->nullable(); // optional: JSON of booked slots
            $table->decimal('in_person_fee', 8, 2)->nullable(); // 💰 New
            $table->decimal('video_fee', 8, 2)->nullable(); // 💰 New
            $table->boolean('status')->default(1); // 1 = Active, 0 = Inactive
            $table->text('other')->nullable();
            $table->timestamps();

            // Foreign keys (if needed)
            $table->foreign('clinic_id')->references('id')->on('clinics')->onDelete('cascade');
            $table->foreign('doctor_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('doctor_availability');
    }
}
