<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doctor_subscription_limits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->constrained('doctor_subscription_members')->onDelete('cascade');
            $table->foreignId('usage_type_id')->constrained('usage_types')->onDelete('restrict');
            
            // Limits and usage
            $table->unsignedInteger('allocated')->default(0);
            $table->unsignedInteger('used')->default(0);
            $table->unsignedInteger('reserved')->default(0);
            
            // Management flags
            $table->boolean('uses_shared_pool')->default(true);
            $table->boolean('allow_overage')->default(false);
            $table->decimal('overage_rate_multiplier', 5, 2)->default(1.0);
            
            $table->timestamps();
            
            $table->unique(['member_id', 'usage_type_id']);
            $table->index(['usage_type_id', 'allocated']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doctor_subscription_limits');
    }
};
