<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('doctor_clinic', function (Blueprint $table) {
            $table->id();
            $table->foreignId('doctor_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('clinic_id')->constrained()->onDelete('cascade');
            $table->foreignId('added_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('subscription_member_id')->nullable()
                ->constrained('doctor_subscription_members')->onDelete('set null');

            // Basic Info
            $table->boolean('is_primary')->default(false);
            $table->enum('status', ['active', 'inactive', 'pending'])->default('active');
            $table->enum('approval_status', ['pending', 'approved', 'rejected'])->default('pending');

            // Service Settings
            $table->decimal('in_person_fee', 10, 2)->nullable();
            $table->decimal('video_fee', 10, 2)->nullable();
            $table->decimal('home_visit_fee', 10, 2)->nullable();
            $table->integer('in_person_duration')->default(15);
            $table->integer('video_duration')->default(15);
            $table->integer('home_visit_duration')->default(30);
            $table->boolean('offers_in_person')->default(true);
            $table->boolean('offers_video')->default(true);
            $table->boolean('offers_home_visit')->default(false);

            // Permission Fields
            $table->json('extra_permissions')->nullable()->comment('Additional permissions beyond role defaults');
            $table->json('disabled_permissions')->nullable()->comment('Permissions to disable from role defaults');
            $table->boolean('override_default_permissions')->default(false)
                ->comment('When true, only extra_permissions are used');

            // Limits
            $table->integer('device_limit')->nullable()->comment('Overrides subscription limits');

            // Timestamps
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();
            $table->unique(['doctor_id', 'clinic_id']);
            //$table->unique(['clinic_id', 'is_primary'], 'unique_primary_per_clinic')->where('is_primary', true);
            //$table->unique(['doctor_id', 'is_primary'], 'unique_primary_per_doctor')->where('is_primary', true);
        });

        Schema::table('doctor_clinic', function (Blueprint $table) {
            $table->index(['added_by'], 'idx_added_by');
            $table->index(['doctor_id', 'clinic_id', 'status'], 'idx_doctor_clinic_status');
            $table->index(['is_primary', 'status'], 'idx_primary_status');
        });
    }

    public function down()
    {
        Schema::dropIfExists('doctor_clinic');
    }
};