<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('combo_plan_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('combo_plan_id')->constrained('subscription_plans')->onDelete('cascade');
            $table->enum('item_type', ['plan', 'addon']);
            $table->unsignedBigInteger('item_id');
            $table->integer('quantity')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('combo_plan_items');
    }
};
