<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('free_unit_balances', function (Blueprint $table) {
            $table->id(); 
            $table->unsignedBigInteger('subscription_id');
            $table->unsignedBigInteger('usage_type_id');
            $table->date('cycle_start_date');
            $table->date('cycle_end_date');
            $table->integer('total_free_units');
            $table->integer('units_consumed');
            $table->timestamps();
            
            $table->foreign('subscription_id')->references('id')->on('customer_subscriptions');
            $table->foreign('usage_type_id')->references('id')->on('usage_types');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('free_unit_balances');
    }
};
