<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_add_ons', function (Blueprint $table) {
            $table->id(); 
            $table->unsignedBigInteger('subscription_id');
            $table->unsignedBigInteger('addon_id');
            $table->integer('units_purchased');
            $table->decimal('total_amount', 10, 2);
            $table->dateTime('purchase_date');
            $table->timestamps();
            
            $table->foreign('subscription_id')->references('id')->on('customer_subscriptions');
            $table->foreign('addon_id')->references('id')->on('add_ons');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_add_ons');
    }
};
