<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->string('subscription_code', 20)->unique();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('plan_id');
            $table->unsignedBigInteger('clinic_id')->nullable();
            $table->date('start_date');
            $table->date('end_date');
            $table->date('renewal_date');
            $table->enum('status', ['active', 'pending', 'expired', 'canceled'])->default('pending');
            $table->boolean('auto_renew');
            $table->decimal('credits_balance', 10, 2)->default(0);
            $table->date('last_billed_date')->nullable();
            $table->date('next_billing_date')->nullable();
            $table->string('billing_cycle', 20);
            $table->date('last_free_unit_reset_date')->nullable();
            $table->timestamps();

            $table->index('user_id');
            $table->index('status');
            $table->index(['end_date', 'auto_renew']);           
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_subscriptions');
    }
};
