<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plan_limits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('plan_id');
            $table->integer('included_doctors');
            $table->integer('included_staff');
            $table->integer('storage_limit_gb');
            $table->integer('teleconsultation_minutes')->nullable();
            $table->integer('sms_limit')->nullable();
            $table->integer('whatsapp_limit')->nullable();
            $table->decimal('additional_doctor_price', 10, 2)->nullable();
            $table->decimal('additional_staff_price', 10, 2)->nullable();
            $table->timestamps();
            
            $table->foreign('plan_id')->references('id')->on('subscription_plans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plan_limits');
    }
};
