<?php

namespace App\Providers;

use Livewire\Livewire;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use App\Livewire\Components\ClinicLayout;
use App\Livewire\Components\ClinicSelector;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);
        Livewire::component('components.clinic-selector', ClinicSelector::class);
        Livewire::component('components.clinic-layout', ClinicLayout::class);
        Gate::define('clinic-permission', function ($user, $permission) {
            $clinicPermissions = session('staff_clinic_permissions', []);
            return in_array($permission, $clinicPermissions);
        });
        
        if ($this->app->environment('production')) {
            URL::forceScheme('https');
        }
    }
}
