<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UsageType extends Model
{
    use HasFactory;

    protected $fillable = [
        'type_name',
        'description',
        'unit_name',
        'is_active'
    ];

    public function usageRates()
    {
        return $this->hasMany(UsageRate::class);
    }

    public function usageTransactions()
    {
        return $this->hasMany(UsageTransaction::class);
    }

    public function freeUnitBalances()
    {
        return $this->hasMany(FreeUnitBalance::class);
    }
}