<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SystemResourcePool extends Model
{
    protected $fillable = [
        'usage_type_id', 'total_available',
        'allocated', 'reserved'
    ];

    public function usageType()
    {
        return $this->belongsTo(UsageType::class);
    }

    public function available()
    {
        return $this->total_available - ($this->allocated + $this->reserved);
    }
}