<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionAddOn extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_id',
        'addon_id',
        'units_purchased',
        'total_amount',
        'purchase_date'
    ];

    public function subscription()
    {
        return $this->belongsTo(CustomerSubscription::class);
    }

    public function addOn()
    {
        return $this->belongsTo(AddOn::class , 'addon_id');
    }
}