<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DoctorPrescription extends Model
{
    use HasFactory;

    protected $table = 'doctor_prescriptions';

    protected $fillable = [
        'doctor_id',
        'patient_id',
        'appointment_id',
        'type',
        'diagnosis',
        'symptoms',
        'medications',
        'follow_up',
        'notes',
    ];

    protected $casts = [
        'medications' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // relationships
    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function patient()
    {
        return $this->belongsTo(User::class, 'patient_id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id');
    }
}
