<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DoctorEMRDocument extends Model
{
    use HasFactory;

    protected $table = 'doctor_emr_documents';

    protected $fillable = [
        'doctor_id',
        'patient_id',
        'appointment_id',
        'document_type',
        'document_path',
    ];

    // Optional: Accessor for full public URL
    public function getDocumentUrlAttribute()
    {
        return url('storage/' . $this->document_path);
    }

    // Relationships (optional)
    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function patient()
    {
        return $this->belongsTo(User::class, 'patient_id');
    }

    public function appointment()
    {
        return $this->belongsTo(App\Models\Appointment::class, 'appointment_id');
    }
}
