<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Doctor extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'status',
        'specialization',
        'qualifications',
        'experience_years',
        'license_number',
        'bio',
        'profile_image',
        'booking_type', // <-- add this
        'certificate',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::saving(function ($doctor) {
            if ($doctor->isDirty('specialization') && $doctor->doctorProfile) {
                $doctor->doctorProfile->update([
                    'specialization' => $doctor->specialization
                ]);
            }
        });
    }
}
