<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerSubscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_code',
        'user_id',
        'plan_id',
        'clinic_id',
        'start_date',
        'end_date',
        'renewal_date',
        'status',
        'auto_renew',
        'credits_balance',
        'last_billed_date',
        'next_billing_date',
        'billing_cycle',
        'last_free_unit_reset_date'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function plan()
    {
        return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
    }

    public function owner()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function creditTransactions()
    {
        return $this->hasMany(CreditTransaction::class);
    }

    public function freeUnitBalances()
    {
        return $this->hasMany(FreeUnitBalance::class);
    }

    public function usageTransactions()
    {
        return $this->hasMany(UsageTransaction::class);
    }

    public function subscriptionAddOns()
    {
        return $this->hasMany(SubscriptionAddOn::class, 'subscription_id');
    }
}
