<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComboPlanItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'combo_plan_id',
        'item_type',
        'item_id',
        'quantity',
    ];

    /**
     * The combo plan this item belongs to
     */
    public function comboPlan()
    {
        return $this->belongsTo(SubscriptionPlan::class, 'combo_plan_id');
    }

    /**
     * Optionally, dynamic relation to item (plan or addon)
     */
    public function item()
    {
        if ($this->item_type === 'plan') {
            return $this->belongsTo(SubscriptionPlan::class, 'item_id');
        } elseif ($this->item_type === 'addon') {
            return $this->belongsTo(AddOn::class, 'item_id');
        }

        return null;
    }
}
