<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AddOn extends Model
{
    use HasFactory;

    protected $fillable = [
        'addon_code',
        'name',
        'resource_type',
        'unit',
        'price_per_unit',
        'billing_cycle',
        'unit_counts',
        'description',
        'is_active'
    ];

    public function subscriptionAddOns()
    {
        return $this->hasMany(SubscriptionAddOn::class , 'addon_id');
    }

    public function comboPlanItems()
    {
        return $this->hasMany(ComboPlanItem::class , 'item_id');
    }

    public function addonItems()
    {
        return $this->comboPlanItems()->where('item_type', 'addon');
    }
}