<?php

namespace App\Livewire\User;

use Livewire\Component;
use Illuminate\Support\Facades\Mail;
use App\Mail\ForgotPasswordMail;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Support\Carbon;

class ForgotPasswordForm extends Component
{
    public $email = '';
    public $status = '';
    public $disable = false;
    public $token;

    protected $rules = [
        'email' => 'required|email|exists:users,email'
    ];

    protected $messages = [
        'email.exists' => 'The provided email does not exist in our records.'
    ];

    public function generateToken()
    {
        $this->token = Str::random(60);
        
        DB::table('password_reset_tokens')->updateOrInsert(
            ['email' => $this->email],
            [
                'token' => hash('sha256', $this->token),
                'created_at' => Carbon::now()
            ]
        );
        
        return $this->token;
    }

    public function sendResetLink()
    {
        $this->validate();
        $this->disable = true;

        try {
            $user = User::where('email', $this->email)->firstOrFail();
            $token = $this->generateToken();
            
            
            $resetUrl = route('password.reset', [
                'token' => $token,
                'email' => $this->email
            ]);

            
            Mail::to($this->email)->send(
                new ForgotPasswordMail(
                    $user->name, 
                    $resetUrl     
                )
            );
            notyf()->success('We have emailed your password reset link!');
            $this->status = 'We have emailed your password reset link!';
        } catch (\Exception $e) {
            logger()->error('Password reset error: ' . $e->getMessage());
            $this->status = 'Failed to send reset link. Please try again later.';
            $this->disable = false;
        }

        $this->dispatch('reset-complete');
    }

    public function render()
    {
        return view('livewire.user.forgot-password-form');
    }
}