<?php

namespace App\Livewire\Doctor\ClinicSelector;

use Livewire\Component;
use Illuminate\Support\Facades\Log;
use App\Services\DoctorClinicService;

class ClinicSelector extends Component
{
    public $selectedClinic;
    public $clinics = [];
    public $isOpen = false;

    public function mount(DoctorClinicService $clinicService)
    {
        $this->clinics = $clinicService->getAvailableClinics(auth()->user());

        $previousClinic = session('current_clinic_id');

        $primaryClinic = collect($this->clinics)->firstWhere('is_primary', true);
        if ($previousClinic && collect($this->clinics)->contains('id', $previousClinic)) {
            $this->selectedClinic = $previousClinic;
        } elseif ($primaryClinic) {
            $this->selectedClinic = $primaryClinic['id'];
            session(['current_clinic_id' => $primaryClinic['id']]);
        } elseif (!empty($this->clinics)) {
            $this->selectedClinic = $this->clinics[0]['id'];
            session(['current_clinic_id' => $this->clinics[0]['id']]);
        } else {
            $this->selectedClinic = null;
        }
        if ($this->selectedClinic) {
            $association = $clinicService->getClinicAssociation(auth()->user(), $this->selectedClinic);
            if ($association) {
                session(['clinic_role' => $association['role_type']]);
            }
        }
    }

    public function selectClinic($clinicId)
    {
        $user = auth()->user();

        Log::channel('permissions')->info('Clinic selection changed', [
            'user_id' => $user->id,
            'previous_clinic' => session('current_clinic_id'),
            'new_clinic' => $clinicId
        ]);

        session(['current_clinic_id' => $clinicId]);
        $this->selectedClinic = $clinicId;
        $this->isOpen = false;

        $clinicService = app(DoctorClinicService::class);
        $association = $clinicService->getClinicAssociation($user, $clinicId);

        if ($association) {
            $role = $association['role_type'];
            Log::channel('permissions')->info('Clinic role assigned', [
                'user_id' => $user->id,
                'clinic_id' => $clinicId,
                'role' => $role,
                'is_primary' => $association['is_primary']
            ]);
            session(['clinic_role' => $role]);
        }

        //$this->js('window.location.reload()');
        $this->dispatch('clinic-changed-refresh');
    }


    public function render()
    {
        $currentClinic = collect($this->clinics)->firstWhere('id', $this->selectedClinic);

        return view('livewire.doctor.clinic-selector.clinic-selector', [
            'currentClinic' => $currentClinic
        ]);
    }
}