<?php

namespace App\Livewire\Admin\SubscriptionPlanWizard;

use Livewire\Component;
use App\Models\UsageType;

class Step4UsageRates extends Component
{
    public $usage_rates = [];
    public $available_usage_types = [];

    public $current_usage_type;
    public $unit = "";
    public $current_rate_per_unit;
    public $current_free_units = 0;
    public $current_overage_rate = 0;
    public $currency;
    public function mount($data = null, $currency = null)
    {
        $this->available_usage_types = UsageType::where('is_active', true)->get();
        $this->currency = $currency ?? 'USD';

        if ($data) {
            $this->usage_rates = $data;
        }
    }

    public function addUsageRate()
    {
        $this->validate([
            'current_usage_type' => 'required|exists:usage_types,id',
            'current_rate_per_unit' => 'required|numeric|min:0',
            'current_free_units' => 'required|integer|min:0',
            'current_overage_rate' => 'nullable|numeric|min:0',
        ]);

        $this->usage_rates[] = [
            'usage_type_id' => $this->current_usage_type,
            'rate_per_unit' => $this->current_rate_per_unit,
            'free_units' => $this->current_free_units,
            'overage_rate' => $this->current_overage_rate,
        ];

        $this->reset(['current_usage_type', 'current_rate_per_unit', 'current_free_units', 'current_overage_rate']);
    }

    public function removeUsageRate($index)
    {
        unset($this->usage_rates[$index]);
        $this->usage_rates = array_values($this->usage_rates);
    }

    public function previous()
    {
        $this->dispatch('goToStep', step: 3);
    }

    public function next()
    {
        $this->dispatch('updatePlanData', step: 'rates', data: $this->usage_rates);
        $this->dispatch('goToStep', step: 5);
    }

    public function updateUnitFromUsageType()
    {
        $selectedType = collect($this->available_usage_types)
            ->firstWhere('id', $this->current_usage_type);

        if ($selectedType) {
            $this->unit = $selectedType->unit_name;
        }
    }

    public function render()
    {
        return view('livewire.admin.subscription-plan-wizard.step4-usage-rates');
    }
}
