<?php

namespace App\Livewire\Admin\SubscriptionPlanWizard;

use Livewire\Component;
use App\Models\Feature;

class Step3PlanFeatures extends Component
{
    public $selected_features = [];
    public $available_features = [];

    public function mount($data = null, $isEditing = false, $currency = null)
    {
        $this->available_features = Feature::where('feature_status', 'active')->get();
        $this->currency = $currency;

        if ($data) {
            $this->selected_features = $data;
        }
    }

    public function rules()
    {
        return [
            'selected_features' => [
                'required',
                'array',
                function ($attribute, $value, $fail) {
                    $validIds = $this->available_features->pluck('id')->toArray();
                    $invalid = array_diff($value, $validIds);
                    if (!empty($invalid)) {
                        $fail('One or more selected features are invalid.');
                    }
                }
            ],
        ];
    }

    public function messages()
    {
        return [
            'selected_features.required' => 'Please select at least one feature.',
        ];
    }

    public function previous()
    {
        $this->dispatch('goToStep', step: 2);
    }

    public function next()
    {
        $this->validate();
        $this->dispatch('updatePlanData', step: 'features', data: $this->selected_features);
        $this->dispatch('goToStep', step: 4);
    }

    public function render()
    {
        return view('livewire.admin.subscription-plan-wizard.step3-plan-features');
    }
}