<?php

namespace App\Livewire\Admin\Plans;

use App\Models\Feature;
use Livewire\Component;

class FeatureForm extends Component
{
    public $feature_code;
    public $feature_name;
    public $description;
    public $is_base_feature = false;
    public $feature_status = 'active';
    public $category;
    public $feature;

    public function mount(Feature $feature = null)
    {
        $this->feature = $feature;

        if ($this->feature && $this->feature->id) {
            $this->feature_code = $this->feature->feature_code;
            $this->feature_name = $this->feature->feature_name;
            $this->description = $this->feature->description;
            $this->is_base_feature = $this->feature->is_base_feature;
            $this->feature_status = $this->feature->feature_status;
            $this->category = $this->feature->category;
        }
    }

    protected function rules()
    {
        $rules = [
            'feature_code' => 'required|string|max:25|unique:features,feature_code',
            'feature_name' => 'required|string|max:100',
            'description' => 'nullable|string',
            'is_base_feature' => 'required|boolean',
            'feature_status' => 'required|in:active,inactive,beta',
            'category' => 'nullable|string|max:50',
        ];

        if ($this->feature && $this->feature->id) {
            $rules['feature_code'] = 'required|string|max:25|unique:features,feature_code,' . $this->feature->id;
        }

        return $rules;
    }

    public function save()
    {
        $this->validate();

        $data = [
            'feature_code' => $this->feature_code,
            'feature_name' => $this->feature_name,
            'description' => $this->description,
            'is_base_feature' => $this->is_base_feature,
            'feature_status' => $this->feature_status,
            'category' => $this->category,
        ];

        if ($this->feature && $this->feature->exists) {
            $this->feature->update($data);
            $this->feature->refresh();
            notyf()->success('Feature updated successfully.');
        } else {
            Feature::create($data);
            notyf()->success('Feature created successfully.');
            return redirect()->route('admin.plans.features.index');
        }

    }

    public function render()
    {
        return view('livewire.admin.plans.feature-form');
    }
}