<?php  

namespace App\Livewire\Admin\Doctor;

use App\Models\User;
use Livewire\Component;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Gate;

class DoctorView extends Component
{
    public $doctor;
    public $educations;
    public $experiences;
    public $clinics;
    public $primaryClinic;

    public function mount($id)
    {
        Gate::authorize('view doctor profile');

        $this->doctor = User::with([
            'doctor',
            'doctorProfile',
            'doctorProfile.educations',
            'doctorProfile.experiences',
            'clinics' => function ($query) {
                $query->withPivot([
                    'is_primary',
                    'status',
                    'approval_status',
                    'approved_at',
                    'in_person_fee',
                    'video_fee',
                    'home_visit_fee',
                    'in_person_duration',
                    'video_duration',
                    'home_visit_duration',
                    'offers_in_person',
                    'offers_video',
                    'offers_home_visit'
                ]);
            },
            'primaryClinics'
        ])->findOrFail($id);

        $this->educations = $this->doctor->doctorProfile->educations ?? collect();
        $this->experiences = $this->doctor->doctorProfile->experiences ?? collect();
        $this->clinics = $this->doctor->clinics ?? collect();
        $this->primaryClinic = $this->doctor->primaryClinics->first();

        Log::info('Doctor data:', $this->doctor->toArray());
    }

    public function render()
    {
        return view('livewire.admin.doctor.doctor-view');
    }
}