<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string|null  ...$guards
     */
    public function handle($request, Closure $next, ...$guards)
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                $user = Auth::guard($guard)->user();
                if ($user->hasRole('doctor') || $user->hasRole('primary_doctor')) {
                    return redirect()->route('doctor.doctor-dashboard');
                }
                if ($user->hasRole('superadmin') || $user->hasRole('superadminstaff')) {
                    return redirect()->route('admin.dashboard');
                }
                if ($user->hasRole('patient')) {
                    return redirect()->route('patient.patient-dashboard');
                }
                return redirect('/home');
            }
        }

        return $next($request);
    }
}