<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\ActiveDevice;
use Carbon\Carbon;

class CheckActiveDevice
{
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            $userId = Auth::id();
            $deviceId = Session::get('device_id');
            $sessionId = Session::getId();
            
            if (!$deviceId) {
                $this->forceLogout();
                return redirect()->route('admin.login')->with('error', 'Session invalid');
            }

            $device = ActiveDevice::where('user_id', $userId)
                ->where('device_id', $deviceId)
                ->first();

            if (!$device || !$device->is_active) {
                $this->forceLogout();
                return redirect()->route('admin.login')->with('error', 'Your session has been terminated');
            }

            if ($device->last_active_at && Carbon::now()->diffInMinutes($device->last_active_at) > 30) {
                $device->update([
                    'is_active' => false,
                    'logout_at' => now()
                ]);
                
                $this->forceLogout();
                return redirect()->route('admin.login')->with('error', 'Session expired due to inactivity');
            }

            if ($device->session_id !== $sessionId) {
                $device->session_id = $sessionId;
                $device->save();
            }

            $this->updateLastActive($device);
        }

        return $next($request);
    }

    protected function forceLogout()
    {
        Auth::logout();
        Session::flush();
    }

    protected function updateLastActive($device)
    {
        if (!$device->last_active_at || Carbon::now()->diffInMinutes($device->last_active_at) >= 1) {
            $device->last_active_at = now();
            $device->save();
        }
    }
}