<?php

namespace App\Http\Controllers\Patient\Auth;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\ActiveDevice;

class PatientAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('patient.auth.login', ['role' => 'patient']);
    }

    public function logout(Request $request)
    {
        $user = Auth::user();

        ActiveDevice::where('user_id', $user->id)
            ->where('device_id', $request->userAgent())
            ->where('role_type', 'patient')
            ->update([
                'is_active' => false,
                'last_active_at' => now(),
            ]);
        foreach (['web', 'superadmin', 'doctor', 'staff', 'patient'] as $guard) {
            if (Auth::guard($guard)->check()) {
                Auth::guard($guard)->logout();
                Session::flush();
                Session::regenerate();
                break;
            }
        }
        Session::forget('current_role');
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('patient.login');
    }

    public function registration()
    {
        return view('Pages.register');
    }

    function profile()
    {
        return view('patient.profile.profile');
    }
}
