<?php

// app/Http/Controllers/InvoiceController.php
// namespace App\Http\Controllers;

// use Illuminate\Http\Request;
// use App\Models\Appointment;
// use Barryvdh\DomPDF\Facade\Pdf;

// class InvoiceController extends Controller
// {
//     public function show($id)
//     {
//         $appointment = Appointment::with(['doctor','patient'])->findOrFail($id);

//         return view('invoice', [
//             'doctor' => $appointment->doctor,
//             'patient' => $appointment->patient,
//             'appointment' => $appointment
//         ]);
//     }

//     public function download($id)
//     {
//         $appointment = Appointment::with(['doctor','patient'])->findOrFail($id);

//         $pdf = Pdf::loadView('invoice', [
//             'doctor' => $appointment->doctor,
//             'patient' => $appointment->patient,
//             'appointment' => $appointment
//         ]);

//         return $pdf->download("invoice-{$appointment->id}.pdf");
//     }
// }

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Appointment;
use PDF; // DomPDF ka alias agar aap use kar rahe ho

class InvoiceController extends Controller
{
    public function show($id)
    {
        // Yaha aap invoice data fetch karoge
        //$invoice = \App\Models\Appointment::where('appointment_number', $id)->firstOrFail();

        return view('invoice');
    }

    // public function downloadInvoice($id)
    // {
    //     $invoice = \App\Models\Appointment::where('appointment_number', $id)->firstOrFail();

    //     $pdf = \PDF::loadView('invoice', compact('invoice'));
    //     return $pdf->download("invoice-{$id}.pdf");
    // }
    // public function downloadInvoice($id)
    // {
    //     // Fetch invoice using numeric ID
    //     $invoice = \App\Models\Appointment::where('id', $id)->firstOrFail();

    //     // Generate PDF using invoice blade
    //     $pdf = \PDF::loadView('invoice', compact('invoice'));

    //     // Return download with filename
    //     return $pdf->download("invoice-{$id}.pdf");
    // }

    public function downloadInvoice($id)
    {
        $invoice = Appointment::where('id', $id)->firstOrFail();

        $pdf = PDF::loadView('invoice', compact('invoice'))
                  ->setPaper('a4', 'portrait'); // optional: paper size

        return $pdf->download("invoice-{$id}.pdf");
    }

}




